// Inicializa carrinho
let carrinho = JSON.parse(localStorage.getItem('carrinho')) || [];

// Função para atualizar o carrinho, chamada quando o carrinho mudar
async function atualizarCarrinho() {
    const loader = document.getElementById('carrinho-loading');
    loader.style.display = 'flex'; // mostra o loader

    try {
        localStorage.setItem('carrinho', JSON.stringify(carrinho));

        const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
        const lojaSlug = blocoSelecionado
            ? blocoSelecionado.getAttribute('data-loja')
            : null;

        const totalItensLojaAtual = carrinho
            .filter(item => item.loja === lojaSlug)
            .reduce((acc, item) => acc + item.quantidade, 0);

        document.getElementById('contador-carrinho').innerText = totalItensLojaAtual;

        await verificarProdutosPublicados();
        renderizarCarrinho();
    } finally {
        loader.style.display = 'none'; 
    }
}

// Finalizar e Criar pedido dos produtos
async function finalizarPedido() {
    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    await verificarLojaAberta();


    const cnpj = await pegarCNPJ(lojaSlug);


    const produtos = carrinho.filter(p => p.loja === lojaSlug);
    if (produtos.length === 0) {
        Swal.fire('Carrinho vazio', 'Adicione itens antes de finalizar.', 'info');
        return;
    }

    const $sel = $('input[name="opcao-endereco"]:checked');
    const d = $sel.data() || {};

    const cep    = (d.cep ?? '').toString().trim();
    const cidade = (d.cidade ?? '').toString().trim();
    const bairro = (d.bairro ?? '').toString().trim();
    const rua    = (d.rua ?? '').toString().trim();
    const numero = (d.numero ?? '').toString().trim();
    const estado = (d.estado ?? '').toString().trim();
    const complemento = (d.complemento ?? '').toString().trim();

    const lat = Number.isFinite(parseFloat(d.lat)) ? parseFloat(d.lat) : NaN;
    const lng = Number.isFinite(parseFloat(d.lng)) ? parseFloat(d.lng) : NaN;

    // só itens (sem frete) -> ERP
    let valorProdutos = produtos.reduce((acc, p) => {
        const precoOferta = parseFloat(p.preco_oferta) || 0;
        const qnt = parseInt(p.quantidade) || 0;
        return acc + (precoOferta * qnt);
    }, 0);
    valorProdutos = parseFloat(valorProdutos.toFixed(2));

    const frete = parseFloat(document.getElementById('valorFrete')?.value || 0) || 0;
    let valorTotalLocal = parseFloat((valorProdutos + frete).toFixed(2));

    const valorFormatado = valorTotalLocal.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });

    Swal.fire({
        title: 'Deseja finalizar o pedido?',
        text: `Você está prestes a enviar seu pré-pedido no valor de ${valorFormatado}.`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sim, finalizar',
        cancelButtonText: 'Cancelar'
    }).then(async (result) => {

    if (!result.isConfirmed) return;

    const cliente = {
        clienteUUID: idUsuario,
        nome: document.getElementById('nome').value,
        cpf: document.getElementById('cpf').value,
        telefone: document.getElementById('telefone').value
    };

    const corpo = {
        action: 'create',
        numeroPedido: Math.floor(Date.now() / 1000),
        cnpj: cnpj,
        loja: lojaSlug,
        cliente,
        tipo: $('input[name="retirada"]:checked').val(),
        meioPagamento: $('input[name="pagamento"]:checked').val(),
        endereco: {
            cep: cep || null,
            cidade: cidade|| null,
            estado: estado || null,
            bairro: bairro || null,
            rua: rua || null,
            numero: numero || null,
            complemento: complemento || null,
            latitude: lat || null,
            longitude: lng || null,
            frete: frete
        },

        // ⬇⬇ BANCO receberá isso (itens + frete)
        valorTotal: valorTotalLocal,

        // ⬇⬇ também enviaremos o "valorProdutos" pro backend calcular o ERP sem frete
        valorProdutos, 

        observacao: $('input[name="retirada"]:checked').val() == 1 ? 'Retirada' : 'Delivery',

        produtos: produtos.map(p => {
            const precoNormal = parseFloat(p.preco_normal) || 0;
            const precoOferta = parseFloat(p.preco_oferta) || 0;
            const quantidade = parseInt(p.quantidade) || 0;
            const valorDesconto = precoNormal > precoOferta ? parseFloat((precoNormal - precoOferta).toFixed(2)) : 0;
            const percDesconto = precoNormal > 0
            ? parseFloat(((valorDesconto / precoNormal) * 100).toFixed(2))
            : 0;

            return {
                codigoProduto: parseInt(p.codigo) || 0,
                quantidade,
                precoNormal,
                precoOferta,
                valorTotal: parseFloat((precoOferta * quantidade).toFixed(2)), // arredonda item
                observacao: p.nome,
                percDesconto,
                valorDesconto,
                smart_campaign: p.smart_campaign
            };
        })
    };

    const telefone = document.getElementById('telefone').value.replace(/\D/g, '');
    const senhaEntrega = telefone.slice(-4);
    localStorage.setItem('senhaEntrega', senhaEntrega);
    corpo.senha = senhaEntrega;

    const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify(corpo)
    });

    const retorno = await res.json();
    if (retorno.success) {

        try {
            localStorage.removeItem('endereco_salvo');
        } catch (e) {
            console.warn('Falha ao limpar endereco_salvo do localStorage:', e);
        }

        // monta mensagem amigável para o cliente
        const isRetirada = $('input[name="retirada"]:checked').val() === '1';
        const msgLinha1  = 'Pedido feito e enviado ao supermercado.';
        const msgSenha   = isRetirada
            ? `\nPara retirada do produto, lembre-se: sua senha é ${senhaEntrega}.`
            : '';
        const msgFinal   = `${msgLinha1}${msgSenha}`;

        // ✅ Mostra ao cliente
        await Swal.fire('Sucesso!', msgFinal, 'success');

        try {
            const idsParaNotificar = Array.isArray(retorno.ids)
            ? retorno.ids
            : (retorno.pedidoId ? [retorno.pedidoId] : []);

            if (idsParaNotificar.length > 0) {
            await fetch('/wp-content/themes/app/web-panel/modules/ecommerce/server-side/server-processing-ecommerce.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                action: 'mensagemCliente',
                ids: idsParaNotificar,
                context: 'pedido_criado', 
                senha_retirada: senhaEntrega
                })
            });
            }
        } catch (e) {
            // silêncio: não bloqueia o fluxo do cliente
            console.warn('Falha ao notificar mensagemCliente:', e);
        }

        // segue seu fluxo atual
        document.querySelectorAll('.modal.show').forEach(modalEl => {
            const modalInstance = bootstrap.Modal.getInstance(modalEl);
            if (modalInstance) modalInstance.hide();
        });
   
        $('#sacola').addClass('open');
        fecharModais();
        $('input[name="retirada"]').prop('checked', false);
        $('input[name="pagamento"]').prop('checked', false);
        $('#pagamento').hide();
        $('#entrega').hide();
        $('#retirada').hide();
        $('#continuarBtn').addClass('disabled');
        document.querySelector('.lista-pagamentos.mb-3').style.display = 'block';
        document.getElementById('continuarBtn').disabled = true;
        carrinho = [];
        atualizarCarrinho();
        carregarSacola();

        } else {
            Swal.fire('Erro', retorno.message || 'Não foi possível gravar.', 'error');
        }

    });
}

// Fechar modais
function fecharModais(){
    $('#modal-carrinho').removeClass('open');
    $('#modal-retirada').removeClass('open');
    $('#modal-revisao').removeClass('open');
}

// Botão dos mapas de entrega para abrir modal de endereço
function abrirModalEndereco() {
    $('#change-password').addClass('open');
    fecharModais();

    // limpa abas ativas
    $('#change-password .tab-item').removeClass('active').attr('aria-selected', 'false');
    $('#change-password .tab-content').removeClass('active');

    // ativa a aba "Endereço para entrega"
    $('#change-password .tab-item[data-tab-content="tab-3"]').addClass('active').attr('aria-selected', 'true');
    $('#tab-3').addClass('active');
}

// Função para alterar a quantidade de um item para -
async function alterarQuantidade(index, delta) {
    const item = carrinho[index];
    if (!item) return;

    const itemVisual = document.querySelectorAll('.item-lista')[index];
    if (itemVisual) itemVisual.classList.add('item-loading');

    item.quantidade += delta;
    if (item.quantidade < 1) item.quantidade = 1;
    if (item.limite && item.quantidade > item.limite) item.quantidade = item.limite;

    await atualizarCarrinho();

    const novosItens = document.querySelectorAll('.item-lista');
    if (novosItens[index]) novosItens[index].classList.remove('item-loading');
}

// Função para alterar a quantidade de um item para +
async function alterarQuantidadeDireto(index, valor) {
    valor = parseInt(valor);
    const item = carrinho[index];
    if (!item) return;

    const itemVisual = document.querySelectorAll('.item-lista')[index];
    if (itemVisual) itemVisual.classList.add('item-loading');

    if (isNaN(valor) || valor < 1) valor = 1;
    if (item.limite && valor > item.limite) valor = item.limite;
    item.quantidade = valor;

    await atualizarCarrinho();

    const novosItens = document.querySelectorAll('.item-lista');
    if (novosItens[index]) novosItens[index].classList.remove('item-loading');
}

// Função para remover um item
function removerItem(index) {
    const container = document.getElementById('itens-carrinho');
    const itemVisual = container.querySelectorAll('.item-lista')[index];

    if (itemVisual) {
        itemVisual.classList.add('removendo');

        setTimeout(() => {
            carrinho.splice(index, 1);
            atualizarCarrinho();
        }, 300); // mesmo tempo do CSS
    }
}

// Função para marcar o item como pego
function marcarPego(index, pego) {
    carrinho[index].pego = pego;
    atualizarCarrinho();
}

// Adicionar ao carrinho
function adicionarAoCarrinho(codigo, nome, imagem, preco_normal, preco_oferta, quantidade, limite = 999, loja = null, smart_campaign = null) {
    const index = carrinho.findIndex(item => item.codigo === codigo && item.loja === loja);

    if (index !== -1) {
        carrinho[index].quantidade += quantidade;
        if (carrinho[index].quantidade > limite) {
            carrinho[index].quantidade = limite;
        }
    } else {
        carrinho.push({ 
            codigo, 
            nome, 
            imagem, 
            preco_normal, 
            preco_oferta, 
            quantidade: Math.min(quantidade, limite), 
            limite,
            loja, 
            pego: false,
            smart_campaign
        });
    }

    atualizarCarrinho();
}

// CheckBox para retirada ou entrega
$(document).ready(function () {
    // Ao alterar a opção de pagamento
    $('input[name="retirada"]').on('change', function () {
        let valor = $(this).val();

        if (valor === '1') {
            $('#retirada').show();
            $('#entrega').hide();
        } else if (valor === '2') {

            $('#entrega').show(); 
            $('#retirada').hide();
        }

        $('#pagamento').show();
    });


    // Dispara ao carregar a página para aplicar a exibição inicial
    $('input[name="retirada"]:checked').trigger('change');
});

// Ao clicar em alguma opção de pagamento
document.querySelectorAll('input[name="pagamento"]').forEach(input => {
    input.addEventListener('change', function () {
        document.querySelectorAll('.opcao-pagamento').forEach(label => {
            label.classList.remove('selected');
        });

        document.getElementById('continuarBtn').disabled = false;
        $('#continuarBtn').removeClass('disabled');
        this.closest('.opcao-pagamento').classList.add('selected');
        atualizarMeioEscolhido();
    });
});

// Atualizar a escrita do meio escolhido
function atualizarMeioEscolhido() {
    const selecionado = document.querySelector('input[name="pagamento"]:checked');
    if (selecionado) {
        const label = selecionado.closest('.opcao-pagamento');
        const texto = label.querySelector('span')?.innerHTML || selecionado.value;
        document.getElementById('meioEscolhido').innerHTML = texto;
    }
}

// Limpa o carrinho
document.getElementById('limpar-carrinho').addEventListener('click', function () {
    Swal.fire({
        title: 'Tem certeza?',
        text: "Seu carrinho será apagado!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sim, limpar!',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            const container = document.getElementById('itens-carrinho');
            const itens = container.querySelectorAll('.item-lista');

            itens.forEach((item, i) => {
                item.classList.add('removendo');
            });

            setTimeout(() => {
                carrinho = [];
                atualizarCarrinho();
                Swal.fire('Carrinho limpo!', '', 'success');
            }, 300); // tempo da animação
        }
    });
});

// Atualiza ao carregar a página
atualizarCarrinho();

// Adicionar ao carrinho, remover do carrinho e atualizar carrinho
document.addEventListener('click', async function (e) {
    const btnAdicionar = e.target.closest('.btn-adicionar');
    if (!btnAdicionar) return; // ✅ primeiro: se não existe, sai

    // ✅ se esse botão também for "Ver opções" (família), NÃO entra no carrinho
    if (btnAdicionar.classList.contains('see-family') || btnAdicionar.closest('.see-family')) {
        return;
    }

    // Adicionar ao carrinho
    e.stopPropagation();

    const container = btnAdicionar.closest('.adicionar-carrinho');
    if (!container) return;

    const input = container.querySelector('.input-quantidade');
    if (!input) return;

    const quantidade = parseInt(input.value, 10) || 1;
    const limite = parseInt(input.getAttribute('max'), 10) || 999;

    let bloco = btnAdicionar.closest('.blocoOfertaApp') || btnAdicionar.closest('.blocoModal');
    if (!bloco) return;

    const nome = bloco.querySelector('.nomeOferta')?.innerText.trim() || '';
    const imagem = bloco.querySelector('img')?.src || '';

    let preco_normal = 0;
    let preco_oferta = 0;

    const precoNormalEl = bloco.querySelector('del');
    const precoOfertaEl = bloco.querySelector('.precoOferta span');

    if (precoNormalEl) {
        preco_normal = parseFloat(precoNormalEl.innerText.replace('R$', '').replace('.', '').replace(',', '.')) || 0;
    } else {
        const precoAntigoEl = document.getElementById('precoAntigo');
        if (precoAntigoEl) {
            preco_normal = parseFloat(precoAntigoEl.innerText.replace('R$', '').replace('.', '').replace(',', '.')) || 0;
        }
    }

    if (precoOfertaEl) {
        preco_oferta = parseFloat(precoOfertaEl.innerText.replace('R$', '').replace('.', '').replace(',', '.')) || 0;
    } else {
        const precoModalEl = document.getElementById('precoOferta');
        if (precoModalEl) {
            preco_oferta = parseFloat(precoModalEl.innerText.replace('R$', '').replace('.', '').replace(',', '.')) || 0;
        } else {
            preco_oferta = preco_normal; // fallback
        }
    }

    const codigo = btnAdicionar.dataset.id || '';
    let loja = btnAdicionar.closest('.individual')?.dataset.loja || null;

    const smart_campaign = btnAdicionar.dataset.smart || null;

    // Se não achou no bloco, tenta pegar no modal
    if (!loja) {
        const lojaInput = document.getElementById('nomeLojaProduto');
        if (lojaInput) loja = lojaInput.value || null;
    }

    if (smart_campaign) {
        const verifica = await checarLimiteProduto(codigo, smart_campaign, quantidade);
        if (!verifica?.success) {
            Swal.fire('Atenção', verifica?.message || 'Limite atingido.', 'warning');
            return;
        }
    }

    adicionarAoCarrinho(codigo, nome, imagem, preco_normal, preco_oferta, quantidade, limite, loja, smart_campaign);

    Swal.fire({
        icon: 'success',
        title: 'Adicionado ao carrinho!',
        text: `Você adicionou ${quantidade}x "${nome}" ao carrinho.`,
        timer: 2000,
        showConfirmButton: false
    });
});


verificarProdutosPublicados();

// Verifica se os produtos do carrinho foram publicados
async function verificarProdutosPublicados() {
    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    const produtosDaLojaAtual = carrinho.filter(item => item.loja == lojaSlug);

    if (produtosDaLojaAtual.length === 0) return;

    const response = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-check-publication.php', {
        method: 'POST',
        body: JSON.stringify(produtosDaLojaAtual)
    });

    const publicados = await response.json();
    
    const codigosPublicados = publicados.map(p => p.codigo);

    const produtosIndisponiveis = produtosDaLojaAtual.filter(p => !codigosPublicados.includes(p.codigo));


    if (produtosIndisponiveis.length > 0) {
        const nomes = produtosIndisponiveis.map(p => `• ${p.nome}`).join('\n');
        Swal.fire({
            icon: 'warning',
            title: 'Produtos removidos do carrinho',
            html: `Os seguintes produtos não estão mais disponíveis:<br><pre style="text-align:center; margin-top: 10px">${nomes}</pre>`,
            confirmButtonText: 'Ok'
        });
    }

    // Remove do carrinho os produtos não publicados
    carrinho = carrinho.filter(p => codigosPublicados.includes(p.codigo));
    localStorage.setItem('carrinho', JSON.stringify(carrinho));
}

// Verifica se o produto tem limite e Limita se necessário
async function checarLimiteProduto(codigoProduto, smart_campaign, quantidade) {
    const response = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            action: 'checar_limite_produto',
            clienteUUID: idUsuario,
            codigoProduto,
            smart_campaign,
            quantidade
        })
    });

    const result = await response.json();
    // console.log(result);
    return result;
}

// Ativa e envia mensagem
function updateCheckboxValue(checkbox) {
    const ativar = checkbox.checked ? 1 : 0;

    formData = new FormData();
    formData.append('action', 'update-ativo');
    formData.append('ativo', ativar);

    $.ajax({
        type: 'POST',
        url: '/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-controler-update-customer.php',
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            try {
                const data = JSON.parse(response);
                if (data.success) {
                    swalPadrao({icon: 'success', title: 'Sucesso', text: 'As mensagens foram ' + (ativar ? 'ativadas' : 'desativadas') + ' com sucesso.'});
                } else {
                    swalPadrao({icon: 'error', title: 'Erro', text: 'Ocorreu um erro ao ' + (ativar ? 'ativar' : 'desativar') + ' as mensagens.'});
                }
            } catch {
                swalPadrao({icon: 'error', title: 'Erro', text: 'Ocorreu um erro ao ' + (ativar ? 'ativar' : 'desativar') + ' as mensagens.'});
            }
        },
        error: function () {
            swalPadrao({icon: 'error', title: 'Erro', text: 'Ocorreu um erro ao ' + (ativar ? 'ativar' : 'desativar') + ' as mensagens.'});
        }
    });
}