// Função para renderizar o carrinho, montar itens em HTML
async function renderizarCarrinho() {
    const container = document.getElementById('itens-carrinho');
    container.innerHTML = '';


    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    const produtosDaLojaAtual = carrinho.filter(item => item.loja == lojaSlug);

    if (produtosDaLojaAtual.length === 0) {
        container.innerHTML = '<p style="text-align:center; padding: 20px;">Seu carrinho está vazio.</p>';
        document.getElementById('total-geral').innerText = 'R$ 0,00';
        // document.getElementById('total-restante').innerText = 'R$ 0,00';
        document.getElementById('total-economia').innerText = 'R$ 0,00';
        $('#limpar-carrinho').hide();
        $('#finalizar-compra').hide();
        $('.btn-custom').hide();
        $('.valor-total').hide();
        return;
    }

    const produtosValidos = carrinho.filter(p => p.loja == lojaSlug);

    if (produtosValidos.length === 0) {
        container.innerHTML = '<p style="text-align:center; padding: 20px;">Seu carrinho está vazio.</p>';
        document.getElementById('total-geral').innerText = 'R$ 0,00';
        // document.getElementById('total-restante').innerText = 'R$ 0,00';
        document.getElementById('total-economia').innerText = 'R$ 0,00';
        $('#limpar-carrinho').hide();
        $('#finalizar-compra').hide();
        $('.btn-custom').hide();
        $('.valor-total').hide();
        return;
    }

    const totalItensLojaAtual = carrinho
    .filter(item => item.loja === lojaSlug)
    .reduce((acc, item) => acc + (parseInt(item.quantidade, 10) || 0), 0);

    document.getElementById('contador-carrinho').innerText = totalItensLojaAtual;


    $('#limpar-carrinho').show();
    $('#finalizar-compra').show();
    $('.btn-custom').show();
    $('.valor-total').show();

    let totalGeral = 0;
    let totalRestante = 0;
    let totalEconomia = 0;
    let smart_campaign = false;

    produtosValidos.forEach(item => {
        const index = carrinho.findIndex(c => c.codigo === item.codigo && c.loja === item.loja);

        // Normaliza: pode vir null, string, etc.
        const precoNormal = Number(item.preco_normal);
        const precoOferta = Number(item.preco_oferta);

        const temNormal = Number.isFinite(precoNormal) && precoNormal > 0;
        const temOferta = Number.isFinite(precoOferta) && precoOferta > 0;

        // Preço usado no cálculo (se não tiver oferta, usa normal)
        const precoUsado = temOferta ? precoOferta : (temNormal ? precoNormal : 0);

        const subtotal = precoUsado * item.quantidade;

        // Só calcula economia se tiver normal e oferta válidos e normal > oferta
        const economia = (temNormal && temOferta && precoNormal > precoOferta)
            ? (precoNormal - precoOferta) * item.quantidade
            : 0;

        smart_campaign = smart_campaign || (parseInt(item.smart_campaign || 0, 10) > 0);

        totalGeral += subtotal;
        totalEconomia += economia;
        if (!item.pego) totalRestante += subtotal;

        // Formata dinheiro com segurança
        const fmt = (v) => (Number.isFinite(v) ? v.toFixed(2).replace('.', ',') : '0,00');

        // Monta a linha de preço dependendo do que existe
        let precosHtml = '';
        if (temNormal && temOferta && precoNormal > precoOferta) {
            precosHtml = `
            <del>R$ ${fmt(precoNormal)}</del>
            <span>R$ ${fmt(precoOferta)}</span>
            `;
        } else if (temOferta) {
            precosHtml = `<span>R$ ${fmt(precoOferta)}</span>`;
        } else if (temNormal) {
            precosHtml = `<span>R$ ${fmt(precoNormal)}</span>`;
        } else {
            precosHtml = `<span>Preço indisponível</span>`;
        }

        const div = document.createElement('div');
        div.classList.add('item-lista');
        div.classList.toggle('item-pego', item.pego);

        div.innerHTML = `
            <div class="item-card">
            <div class="info-produto">
                <p class="nome">${item.nome}</p>
                <p class="precos">${precosHtml}</p>
            </div>
            <div class="acoes">
                <button onclick="alterarQuantidade(${index}, -1)">-</button>
                <span>${item.quantidade}</span>
                <button onclick="alterarQuantidade(${index}, 1)">+</button>
            </div>
            <div class="remover">
                <i class="fa-solid fa-trash-can" onclick="removerItem(${index})"></i>
            </div>
            </div>
        `;

        container.appendChild(div);
    });

    document.getElementById('total-geral').innerText = 'R$ ' + totalGeral.toFixed(2).replace('.', ',');
    // document.getElementById('total-restante').innerText = 'R$ ' + totalRestante.toFixed(2).replace('.', ',');
    document.getElementById('total-economia').innerText = 'R$ ' + totalEconomia.toFixed(2).replace('.', ',');

    if(!smart_campaign){
        verificarEcommerce();
        verificarValorMinimo(totalGeral);
    }
    else{
        const btnFinalizar = document.getElementById('finalizar-compra');
        btnFinalizar.disabled = false;
        btnFinalizar.classList.remove('disabled'); 
        document.querySelector('.lista-pagamentos.mb-3').style.display = 'none';
    } 
}

// Função para controle de que forma vira a revisão, seja retirada ou entrega
async function revisaoControl() {
    const $sel = $('input[name="opcao-endereco"]:checked');
    const d = $sel.data() || {};

    const cep    = (d.cep ?? '').toString().trim();
    const cidade = (d.cidade ?? '').toString().trim();
    const bairro = (d.bairro ?? '').toString().trim();
    const rua    = (d.rua ?? '').toString().trim();
    const numero = (d.numero ?? '').toString().trim();
    const estado = (d.estado ?? '').toString().trim();
    const complemento = (d.complemento ?? '').toString().trim();

    const lat = Number.isFinite(parseFloat(d.lat)) ? parseFloat(d.lat) : NaN;
    const lng = Number.isFinite(parseFloat(d.lng)) ? parseFloat(d.lng) : NaN;

    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    let valor = $('input[name="retirada"]:checked').val();

    if (valor === '1') {
        atualizarMeioEscolhido(); 
        $('#retirada-revisao').show();
        $('#entrega-revisao').hide();
        document.getElementById('valorFrete').value = 0;
        renderizarResumoCompra();
        atualizarNomeLojaNasLabels();
        // $('#modal-pagamento').addClass('open');
        $('#modal-revisao').addClass('open');
    } 
    else if (valor === '2') {
        if (!cep || !cidade || !rua || !bairro || !numero ||!estado) {
            Swal.fire('Atenção', 'Coloque um endereço para continuar.', 'warning');
            return;
        }

        let retorno = null; 

        try {
            const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                    action: 'calcular_frete',
                    cep: cep,
                    cidade: cidade,
                    rua: rua,
                    bairro: bairro,
                    numero: numero,
                    estado: estado,
                    latitude: lat,
                    longitude: lng,
                    loja: lojaSlug
                })
            });

            retorno = await res.json(); 

            if (!retorno.success) {
                Swal.fire('Erro', retorno.message || 'Não foi possível calcular o frete.', 'error');
                abrirModalEndereco();
                return;
            }

            
        } catch (error) {
            Swal.fire('Erro', 'Falha na comunicação com o servidor.', 'error');
            console.error(error);
            return;
        }

        $('#retirada-revisao').hide();
        $('#entrega-revisao').show();

        // document.getElementById('enderecoRevisao').textContent = endereco + (complemento ? ` - ${complemento}` : '');
        

        if(complemento){
            text = ' - ' + complemento;
        }
        else{
            text = '';
        }

        montarMapaEntregaComEndereco(lat, lng, 'mapRevisao',`${rua}, ${numero} - ${bairro}, ${cidade}/${estado}, ${cep} ${text}`);

        document.getElementById('valorFrete').value = retorno.frete;
        renderizarResumoCompra(retorno.frete); 
        atualizarNomeLojaNasLabels();
        // $('#modal-pagamento').addClass('open');
        $('#modal-revisao').addClass('open');
    }
    else{
        Swal.fire('Atenção', 'Selecione uma opção de entrega.', 'warning');
    }
}

// Renderiza o resumo da compra
function renderizarResumoCompra(frete = null) {
    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    const resumoContainer = document.querySelector('.resumo');
    if (!resumoContainer) return;

    const produtos = carrinho.filter(item => item.loja === lojaSlug);
    if (produtos.length === 0) {
        resumoContainer.innerHTML = '<p style="text-align:center;">Nenhum item no carrinho para essa loja.</p>';
        return;
    }

    let html = '';
    let totalGeral = 0;
    let totalEconomia = 0;

    produtos.forEach(item => {
    // Normaliza (pode vir null/string)
    const precoNormal = Number(item.preco_normal);
    const precoOferta = Number(item.preco_oferta);

    const temNormal = Number.isFinite(precoNormal) && precoNormal > 0;
    const temOferta = Number.isFinite(precoOferta) && precoOferta > 0;

    // Preço final: se tiver oferta usa oferta, senão usa normal
    const precoFinal = temOferta ? precoOferta : (temNormal ? precoNormal : 0);

    const subtotal = precoFinal * item.quantidade;

    // Economia só se tiver normal e oferta e normal > oferta
    const economia = (temNormal && temOferta && precoNormal > precoOferta)
        ? (precoNormal - precoOferta) * item.quantidade
        : 0;

    totalGeral += subtotal;
    totalEconomia += economia;

    const fmt = (v) => (Number.isFinite(v) ? v.toFixed(2).replace('.', ',') : '0,00');

    // Preços (HTML) variando conforme existir normal/oferta
    let precosHtml = '';
    if (temNormal && temOferta && precoNormal > precoOferta) {
        precosHtml = `
        <del>R$ ${fmt(precoNormal)}</del>
        <span class="preco-oferta">R$ ${fmt(precoOferta)}</span>
        `;
    } else if (temOferta) {
        precosHtml = `<span class="preco-oferta">R$ ${fmt(precoOferta)}</span>`;
    } else if (temNormal) {
        precosHtml = `<span class="preco-oferta">R$ ${fmt(precoNormal)}</span>`;
    } else {
        precosHtml = `<span class="preco-oferta">Preço indisponível</span>`;
    }

    html += `     
        <div class="item-card">
        <div class="info-produto">
            <p class="nome">${item.nome}</p>
            <p class="precos">
            ${precosHtml}
            <span class="quantidade-badge">x ${item.quantidade}</span>
            </p>
        </div>
        </div>
    `;
    });

    document.getElementById('total-geral-revisao').innerText = 'R$ ' + totalGeral.toFixed(2).replace('.', ',');

    // Exibe frete (se houver e for entrega)
    if (frete !== null && $('input[name="retirada"]:checked').val() === '2') {
        $('#frete-revisao').removeClass('d-none'); // mostra

        document.getElementById('total-frete-revisao').innerText ='R$ ' + frete.toFixed(2).replace('.', ',');

        totalGeral += parseFloat(frete);

    } else {
        $('#frete-revisao').addClass('d-none'); // esconde
    }


    document.getElementById('total-pagar-revisao').innerText = 'R$ ' + totalGeral.toFixed(2).replace('.', ',');
    document.getElementById('total-economia-revisao').innerText = 'R$ ' + totalEconomia.toFixed(2).replace('.', ',');
    resumoContainer.innerHTML = html;
}

//Ao clicar dentro do card dos produtos traz os detalhes
async function revisao(id) {
    try {
        const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'get_revisao', id: id })
        });

        const data = await res.json();

        if (!data.success) {
            Swal.fire('Erro', 'Pedido não encontrado.', 'error');
            return;
        }

        const resumo = document.getElementById('resumo');
        resumo.innerHTML = `
            <div class="skeleton-produto d-flex align-items-start mb-4">
                <div class="me-2 shimmer" style="width: 60px; height: 60px; border-radius: 6px;"></div>
                <div class="flex-grow-1">
                    <div class="shimmer mb-2" style="width: 80%; height: 14px;"></div>
                    <div class="shimmer mb-1" style="width: 60%; height: 12px;"></div>
                    <div class="shimmer" style="width: 40%; height: 12px;"></div>
                </div>
            </div>
            <div class="skeleton-produto d-flex align-items-start mb-4">
                <div class="me-2 shimmer" style="width: 60px; height: 60px; border-radius: 6px;"></div>
                <div class="flex-grow-1">
                    <div class="shimmer mb-2" style="width: 80%; height: 14px;"></div>
                    <div class="shimmer mb-1" style="width: 60%; height: 12px;"></div>
                    <div class="shimmer" style="width: 40%; height: 12px;"></div>
                </div>
            </div>
        `;


        document.getElementById('detalhesModal').classList.add('open');
        // document.getElementById('numeroPedido').innerHTML = `${data.numeroPedido}`;

        tipo = data.tipo;

        const numero = String(data.protocolo || data.numeroPedido || '');

        // monta o cabeçalho com texto + código de barras (CODE128)
        // const titulo = document.getElementById('numeroPedido');
        // titulo.innerHTML = `
        // <div class="mb-2">Pedido #${numero}</div>
        // <svg id="barcode"
        //     jsbarcode-format="CODE128"
        //     jsbarcode-value="${numero}"
        //     jsbarcode-textmargin="2"
        //     jsbarcode-fontsize="14"
        //     jsbarcode-displayvalue="true">
        // </svg>
        // `;

        const titulo = document.getElementById('numeroPedido');
        titulo.innerHTML = `
        <div class="mb-2">Pedido</div>
        <svg id="barcode"
            jsbarcode-format="CODE128"
            jsbarcode-value="${numero}"
            jsbarcode-textmargin="2"
            jsbarcode-fontsize="14"
            jsbarcode-displayvalue="true">
        </svg>
        `;


        if(data.endereco.complemento == null){
            complemento = '';
        }else{
            complemento = ', ' + data.endereco.complemento;
        }

        // inicializa o JsBarcode (com fallback seguro)
        if (window.JsBarcode) {
        try { JsBarcode('#barcode').init(); } catch(e) { console.warn('Barcode erro:', e); }
        } else {
            console.warn('JsBarcode não carregado.');
        }


        if(tipo == 2){

            montarMapaEntregaComEndereco(
                data.lat, 
                data.lng, 
                'revisaoRetirada', 
                `${data.endereco.rua}, ${data.endereco.numero} - ${data.endereco.cidade}/${data.endereco.estado} - ${data.endereco.cep} ${complemento} `,
                true
            );

            $('#map-entrega').show();
            $('#map-retirada').hide();
        }
        else{
            $('#map-entrega').hide();
            $('#map-retirada').show();
        }

        // Determina a classe com base no texto do status
        let statusClass = '';
        switch (data.status) {
            case 'Pendente':
                statusClass = 'text-primary';
                break;
            case 'Em Andamento':
                statusClass = 'text-orange'; // precisa definir essa classe no CSS
                break;
            case 'Pronto para Buscar':
                statusClass = 'text-warning';
                break;
            case 'Finalizado':
                statusClass = 'text-success';
                break;
            case 'Cancelado':
                statusClass = 'text-danger';
                break;
            case 'Saiu para Entrega':
                statusClass = 'text-warning';
                break;
            default:
                statusClass = 'text-muted';
        }

        document.getElementById('status').innerHTML = ` 
            <div class="d-flex align-items-center">
                <strong class="${statusClass} status-piscando mb-1">
                    <i class="fa-solid fa-circle me-1"></i> ${data.status}
                </strong>
            </div>
        `;

        carregarLojaPagamento(data.loja);
        document.getElementById('totalPago').innerText = `R$ ${parseFloat(data.valorTotal).toFixed(2).replace('.', ',')}`;
        document.getElementById('Economia').innerText = `R$ ${parseFloat(data.economia || 0).toFixed(2).replace('.', ',')}`;

        if(tipo == 2){
            $('#frete-historico').removeClass('d-none'); 
            document.getElementById('freteAplicado').innerText = `R$ ${parseFloat(data.frete).toFixed(2).replace('.', ',')}`;
        }
        else{
            $('#frete-historico').addClass('d-none');
        }


        // document.getElementById('revisaoPagamento').innerText = `${data.observacao}`;
        document.getElementById('meioPagamentoEscolhido').innerHTML = `${data.meioPagamento}`;
        
        resumo.innerHTML = data.produtos.map(p => {
            // let imagem = '';

            // if (p.imagem) {
            //     imagem = `<img src="${p.imagem}" alt="${p.observacao}" class="img-produto">`;
            // }

            economia = p.precoNormal - p.precoOferta;

            // return `
            //     <div class="produto-item">
            //         <div class="img-wrapper">
            //             ${imagem}
            //         </div>
            //         <div class="info-produto">
            //             <p class="nome">${p.observacao}</p>
            //             <p class="precos">
            //                 <del>R$ ${p.precoNormal.toFixed(2).replace('.', ',')}</del> 
            //                 <span class="preco-oferta">R$ ${p.precoOferta.toFixed(2).replace('.', ',')}</span>
            //                 <span class="quantidade-badge">x ${p.quantidade}</span>
            //             </p>
            //             <p class="subtotal">
            //                 Subtotal: <strong>R$ ${(p.valorTotal).toFixed(2).replace('.', ',')}</strong>
            //             </p>
            //             <p class="economia">
            //                 Economia: <strong style="color:green;">R$ ${(economia).toFixed(2).replace('.', ',')}</strong>
            //             </p>
            //         </div>
            //     </div>
            // `;

            return `
                <div class="item-card">
                    <div class="info-produto">
                        <p class="nome">${p.observacao}</p>
                        <p class="precos">
                            <del>R$ ${p.precoNormal.toFixed(2).replace('.', ',')}</del> 
                            <span class="preco-oferta">R$ ${p.precoOferta.toFixed(2).replace('.', ',')}</span>
                            <span class="quantidade-badge">x ${p.quantidade}</span>
                        </p>
                    </div>
                </div>
            `;

        }).join('');


    } catch (e) {
        console.error('Erro ao carregar revisão:', e);
        Swal.fire('Erro', 'Erro ao buscar os detalhes do pedido.', 'error');
    }
}

carregarSacola();

// Carrega os pedidos feitos no carrinho
async function carregarSacola() {
    try {
        const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'get_cart', id: idUsuario, senha: localStorage.getItem('senhaEntrega') })
        });

        const data = await res.json();
        const container = document.getElementById('itens-carrinho-sacola');
        container.innerHTML = data.html || '<p class="text-muted">Erro ao carregar sacola.</p>';
        const telefone = document.getElementById('telefone').value.replace(/\D/g, ''); 
        const senha = telefone.slice(-4); 
        document.getElementById('senhaRetirada').innerText = senha;

        botaoDetalhes();
    } catch (e) {
        console.error('Erro ao carregar sacola:', e);
        Swal.fire('Erro', 'Erro ao buscar os itens da sacola.', 'error');
    }
}

// Renderiza o código de barras
function renderProtocoloBarcode(protocolo, selector = '#barcode') {
    if (!protocolo) return;
    JsBarcode(selector, String(protocolo), {
      format: 'CODE128',     
      lineColor: '#000',
      width: 2,             
      height: 60,           
      displayValue: true,   
      fontOptions: 'bold',
      textMargin: 6,
      margin: 8
    });
}

// Botão de detalhes para Abrir a Revisão
function botaoDetalhes() {
    document.querySelectorAll('.btn-ver-mais').forEach(botao => {
        botao.addEventListener('click', function () {
            const id = this.getAttribute('data-id');
            revisao(id); 
        });
    });
} 

// ---- Regra reutilizável ----
function verificarValorMinimo(total) {
    // Valida o valor mínimo de compra
    const btnFinalizar = document.getElementById('finalizar-compra');
    if (total < valor_minimo) {
        btnFinalizar.disabled = true;
        btnFinalizar.classList.add('disabled')
        btnFinalizar.title = `O valor mínimo para finalizar a compra é R$ ${valor_minimo.toFixed(2).replace('.', ',')}`;
    } else {
        btnFinalizar.disabled = false;
        btnFinalizar.classList.remove('disabled');
        btnFinalizar.title = "";
    }
}

function verificarEcommerce() {
    const btnFinalizar = document.getElementById('finalizar-compra');
    if(ecommerce_ativo){
        btnFinalizar.disabled = false;
        btnFinalizar.classList.remove('disabled');
        btnFinalizar.title = "";
    } else{
        btnFinalizar.disabled = true;
        btnFinalizar.classList.add('disabled');
    }
}