const searchInputModal = document.getElementById("searchInputModal");
const searchIcon = document.querySelector('.box-search-product i');
const searchInput = document.getElementById("searchInput");
const productsArea = document.getElementById('listaProdutos');
const icone = document.querySelector('.box__search');
let isSyncing = false;
let listenerCirclesAtivado = false;
const modalElement = document.getElementById('ModalSection');

// FILTROS PARA PEGAR APENAS PRODUTOS DE SEÇÕES, CATEGORIAS, AGENDAS, ETC 
function getAllSectionsToFilter() {
    showFilterSkeleton('chips-secao');
    const sections = getStoredSections();

    // se precisar saber se existe ecommerce, pega do ALL_DATA ou storage
    let hasEcommerce = false;
    try {
        if (typeof ALL_DATA !== 'undefined' && ALL_DATA.ecommerce) {
            hasEcommerce = true;
        } else {
            const rawEcom = localStorage.getItem('ecommerce');
            if (rawEcom) {
                const parsed = JSON.parse(rawEcom);
                hasEcommerce = !!parsed;
            }
        }
    } catch (e) {
        console.warn('Erro ao ler ecommerce do storage:', e);
    }

    // monta lista: "Geral" e (se houver) "Ecommerce" + "Oculto" + seções
    const items = [];

    sections.forEach(secao => {
        items.push({
            id: String(secao.id),
            nome: String(secao.title || 'Sem título'),
            category: secao.category || 0
        });
    });

    items.push({ id: 'geral', nome: 'Geral' });

    if (hasEcommerce) {
        items.push({ id: 'ecommerce', nome: 'Ecommerce' });
    }

    renderRadioList('chips-secao', items, {
        nameAttr: 'secao',
        labelAttr: 'nome',
        valueAttr: 'id'
    });

    // evita acumular vários listeners se chamar getAllSectionsToFilter mais de uma vez
    const wrapper = document.getElementById('chips-secao');
    if (!wrapper) return;

}

function canShowCampaignProductForUser(mainProd) {
    if (!mainProd || !mainProd._campaignData) return true;

    const smartItem = mainProd._campaignData || {};
    const currentUserId   = idUsuario || null;
    const currentUserTags = Array.isArray(window.userTags)
        ? window.userTags.map(String)
        : [];


    // 1) PRODUTO EXCLUSIVO
    const isExclusiveProduct =
        smartItem.hasClienteExclusivo === true ||
        smartItem.isClienteExclusivo === true ||
        (Array.isArray(smartItem.cliente_exclusivo) && smartItem.cliente_exclusivo.length > 0) ||
        (Array.isArray(smartItem.exclusivos) && smartItem.exclusivos.length > 0);

    if (isExclusiveProduct) {
        if (!currentUserId) return false;

        const listaClientes =
            (Array.isArray(smartItem.exclusivos) && smartItem.exclusivos.length)
                ? smartItem.exclusivos
                : (Array.isArray(smartItem.cliente_exclusivo)
                    ? smartItem.cliente_exclusivo
                    : []);

        const canSeeExclusive = listaClientes.some(c =>
            c &&
            (
                String(c.id) === String(currentUserId) ||
                String(c.ID) === String(currentUserId) ||
                String(c.cliente_uuid || '') === String(currentUserId)
            )
        );


        return canSeeExclusive;
    }

    // 2) PRODUTO POR TAG
    let rawTags = [];

    if (Array.isArray(smartItem.tags)) {
        rawTags = smartItem.tags;
    }

    // Se o item tem a propriedade tags definida (mesmo vazia),
    // consideramos que é um produto segmentado por TAG.
    const isTagSegmented = Array.isArray(smartItem.tags);

    // Se NÃO for exclusivo e NÃO for segmentado por tag → produto geral, liberado
    if (!isTagSegmented) {
        return true;
    }

    // A partir daqui: produto segmentado por TAG

    // Produto tem segmentação por tag, mas usuário não tem nenhuma tag → não vê
    if (!currentUserTags.length) {
        return false;
    }

    const tagIdsItem = rawTags
        .map(t => {
            if (t == null) return null;

            if (typeof t === 'string' || typeof t === 'number') {
                return String(t);
            }

            return String(
                t.id_tag || t.tag_id || t.id || t.ID || ''
            );
        })
        .filter(Boolean);

    // Se é produto segmentado por tag, mas não consegui extrair nenhuma tag válida,
    // melhor BLOQUEAR do que liberar errado.
    if (!tagIdsItem.length) {
        return false;
    }

    const userTagSet = new Set(currentUserTags);
    const hasMatch   = tagIdsItem.some(id => userTagSet.has(id));
    return hasMatch;
}


function enrichCampaignItem(rawItem) {
    const item = { ...rawItem };
    let tags = [];

    // Exemplo: se o JSON original tiver algo como rawItem.tags ou rawItem.tags_publico
    let rawTags = rawItem.tags || rawItem.tags_publico || [];

    if (!Array.isArray(rawTags)) {
        rawTags = [rawTags];
    }

    tags = rawTags
        .map(t => {
            if (t == null) return null;

            // se vier como número/string
            if (typeof t === 'string' || typeof t === 'number') {
                return { id_tag: String(t) };
            }

            // se vier como objeto
            const id_tag = t.id_tag || t.tag_id || t.id || t.ID;
            if (!id_tag) return null;

            return {
                ...t,
                id_tag: String(id_tag)
            };
        })
        .filter(Boolean);

    item.tags = tags;

    return item;
}


async function buildSectionsForStore(idSection = null, origin = '') {
    const allProducts    = getStoredProducts() || [];
    const storedSections = getStoredSections() || [];

    const categoriesArea    = document.getElementById('categoriesArea');
    const productsArea      = document.getElementById('productsArea');
    const productsContainer = document.getElementById('listaProdutos');

    const isModal = idSection;

    if (isModal) {
        if (!productsContainer) return;
    } else {
        if (!categoriesArea || !productsArea) return;
    }

    const isCategoriaChip = (origin === 'category');
    const isAgendaChip    = (origin === 'agenda');

    let sectionsToRender = [];

    if (isModal && (isCategoriaChip || isAgendaChip)) {
 
        let catCod  = idSection;

        if(origin == 'category' || origin == 'agenda'){
            catCod  = idSection;
        }

        let prods = [];

        if (origin == 'category') {
            // Categoria
            prods = await GetProductsByCategory(catCod);
        } else if (origin == 'agenda') {
            // Agenda
            prods = await GetProductsByCalendar(catCod);
        }

        if (prods.length) {
            const fakeSection = {
                id: isCategoriaChip
                    ? `cat-${idSection}`
                    : `agenda-${Array.isArray(idSection) ? idSection.join('-') : idSection}`,
                title: isCategoriaChip ? 'Produtos da categoria' : 'Produtos da agenda',
                visibility: 1,
                format: 1,
                category: isCategoriaChip ? idSection : 0,
                type: isCategoriaChip ? 1 : 3,
                data_start: '0000-00-00 00:00:00',
                data_end: '0000-00-00 00:00:00'
            };

            sectionsToRender.push({ section: fakeSection, products: prods });
        }
        
    } 
    else if (isModal) {
        const dyn = storedSections.find(sec => String(sec.id) === String(idSection));
        if (dyn) {
            let offers = dyn.offers || [];
            let catCod = dyn.category;

            if (origin == 'category' || origin == 'agenda') {
                catCod  = idSection;
            }

            const typeSec    = Number(dyn.type || 0);
            const campaignId = Number(dyn.id_smart_campaign || 0) || null;
            const isCampaign = campaignId;

            let prods = [];

            if (typeSec === 1 || origin == 'category') {
                prods = await GetProductsByCategory(catCod);
            } else if (typeSec === 3 || origin == 'agenda') {
                prods = await GetProductsByCalendar(catCod);
            } else {
                prods = getInfoProducts(offers, isCampaign, campaignId);
            }

            if (prods.length) {
                sectionsToRender.push({ section: dyn, products: prods });
            }
        } else {
            // 🔹 Se NÃO achou nas seções dinâmicas, tenta nas FIXAS (geral/oculto/ecommerce)
            const fixedSections = buildFixedSections(allProducts) || [];
            const fixed = fixedSections.find(
                item => String(item.section.id) === String(idSection)
            );

            if (fixed && fixed.products && fixed.products.length) {
                sectionsToRender.push(fixed);
            }
        }
    }
    else {
        // VISÃO NORMAL
        for (const sec of storedSections) {
            let offers  = sec.offers || [];
            const campaignId = Number(sec.id_smart_campaign || 0) || null;
            const isCampaign = !!campaignId;

            const prods = getInfoProducts(offers, isCampaign, campaignId);
            if (prods.length) {
                sectionsToRender.push({ section: sec, products: prods });
            }
        }

        // fixas (continua igual)
        const fixedSections = buildFixedSections(allProducts) || [];
        fixedSections.forEach(item => {
            if (item.products && item.products.length) {
                sectionsToRender.push(item);
            }
        });
    }

    let circlesHtml  = '';
    let productsHtml = '';

    sectionsToRender.forEach(item => {
        const sec   = item.section;
        const prods = item.products;
        if (!prods || !prods.length) return;

        if (!isModal) {
            const img = sec.imagem || sec.image || logo;
            circlesHtml += buildSectionCircleHtml(
                sec.id,
                sec.title,
                img,
                sec.visibility
            );
        }

        // aqui você já passa se é modal ou não (3º parâmetro) como estava antes
        productsHtml += buildSectionProductsHtml(sec, prods, isModal);
    });

    if (isModal) {
        productsContainer.innerHTML = productsHtml;
        fecharModalDisable();
        removerSkeletons();
        searchInputModal.disabled = false;
    } else {
        categoriesArea.innerHTML = circlesHtml;
        productsArea.innerHTML   = productsHtml;
    }
}

function buildSectionProductsHtml(section, produtos, idSection = null) {

    // console.log('section', section);
    // console.log('produtos', produtos);

    const blocoSelecionado = document.querySelector('.bloco-loja.selecionada');
    const lojaSlug = blocoSelecionado
        ? blocoSelecionado.getAttribute('data-loja')
        : null;

    const id         = section.id;
    const idStr      = String(id);
    const titulo     = section.title || 'Sem título';
    const visibility = section.visibility ?? 1;
    let format       = Number(section.format || 1);
    const category   = section.category || 0;

    const idSmart = Number(section.id_smart_campaign || 0);
    const isCampaignSection = idSmart > 0;
    const dataInicio = section.data_start || '0000-00-00 00:00:00';
    const dataFim    = section.data_end   || '0000-00-00 00:00:00';

    let limitShow    = Number(section.limit_show || 0);
    const showPerView = Number(section.show_per_view || 4);

    if (idSection) {
        limitShow = 9999;
        format = 1;
    }

    const groups = groupProductsByFamily(produtos || [])
        .filter(g => g && Array.isArray(g.products) && g.products.length);

    const qtdProdutos = groups.length;
    const isCarousel  = qtdProdutos >= 5 && format === 2;

    const baseContainerClass = isCarousel
        ? 'carousel-sectionProdutos'
        : 'row row-sectionProdutos';

    // 🔹 no modal (idSection !== null) o container vira "sortable-produtos"
    const containerClass = `${baseContainerClass} ${idSection ? 'sortable-produtos' : ''}`.trim();

    // 🔹 no modal, o próprio container recebe data-id da seção
    const containerExtras =
        (isCarousel ? ` data-show="${showPerView}"` : '') +
        (idSection ? ` data-id="${id}"` : '');

    let buttonsHtml = '';

    if (!idSection) {
        buttonsHtml = `<div class="d-flex gap-2">`;
        buttonsHtml += `
            <button class="btn btn-outline-primary ver-mais-btn"
                    data-section="${id}">
                Ver mais
            </button>
        `;

        buttonsHtml += `</div>`;
    }

    let cronometroHtml = '';
    if (idSmart > 0 && !idSection) {
        cronometroHtml = `
        <div class="cronometro text-danger"
             data-start="${dataInicio}"
             data-end="${dataFim}"
             id="cronometro-${id}">
            Exclusivo até:
            <div class="timer">
                <div><span class="days">00</span><small>Dias</small></div>
                <div><span class="hours">00</span><small>Horas</small></div>
                <div><span class="minutes">00</span><small>Minutos</small></div>
                <div><span class="seconds">00</span><small>Segundos</small></div>
            </div>
        </div>`;
    }

    let html = `
    <div class="sectionContent mb-5"
         id="section-${id}"
         data-visibility="${visibility}"
         data-format="${format}"
         data-id="${id}"
         data-category="${category}"
         data-smart="${idSmart}"
         data-start="${dataInicio}"
         data-end="${dataFim}">
        <div class="d-flex justify-content-between align-items-center">
            <h2 class="section-title fw-bold text-dark mb-4">${titulo}</h2>
            ${buttonsHtml}
        </div>
        ${cronometroHtml}
        <div class="${containerClass}"${containerExtras}>
    `;

    // --------- LOOP DOS GRUPOS (famílias) COM LIMIT_SHOW ---------
        // --------- LOOP DOS GRUPOS (famílias) COM LIMIT_SHOW ---------
    let rendered = 0;

    const formatMoney = (v) =>
        Number(v || 0).toFixed(2).replace('.', ',');

    for (const group of groups) {
        if (limitShow > 0 && rendered >= limitShow) break;

        const lojaIdBruta = lojaSlug ? String(lojaSlug).replace('loja-', '') : '';

        const resolveLojaKey = (precosPorLoja, lojaIdBruta) => {
            if (!lojaIdBruta) return '';

            const idSemZeros = String(lojaIdBruta).replace(/^0+/, ''); // "001" -> "1"
            const idPad3     = idSemZeros.padStart(3, '0');            // "1"   -> "001"

            if (precosPorLoja[idPad3])     return idPad3;
            if (precosPorLoja[idSemZeros]) return idSemZeros;

            return '';
        };

        // 🔹 Para campanha: filtra os produtos da família pelo que o usuário PODE ver
        let visibleProducts = group.products;

        if (isCampaignSection) {
            visibleProducts = group.products.filter(p => canShowCampaignProductForUser(p));
        }

        // se depois do filtro não sobrou nada nessa família, não renderiza o card
        if (!visibleProducts.length) continue;

        // agora o "produto principal" é o primeiro visível
        const mainProd = visibleProducts[0];
        if (!mainProd) continue;

        // 🔹 FILTRO DE STATUS CORRETO AQUI
        if (mainProd.status) {
            const st = mainProd.status;

            if (isCampaignSection) {
                // campanha → aceita publish e draft
                if (st !== 'publish' && st !== 'draft') continue;
            } else {
                // seção normal → só publish
                if (st !== 'publish') continue;
            }
        }

        if(visibility == 0){
            continue;
        }

        const PLACEHOLDER_IMG = `${window.location.origin}/wp-content/themes/app/web-panel/dist/images/search-images/placeholder.jpg`;

        const codigo      = mainProd.codigo != null ? String(mainProd.codigo) : '';
        const tituloProd  = mainProd.titulo || '';
        const imagemProd = (typeof imagemProdRaw === 'string' && imagemProdRaw.trim() !== '')
        ? imagemProdRaw.trim()
        : PLACEHOLDER_IMG;

        const prodId      = mainProd.id || '';
        const familia     = mainProd.familia || null;
        const lojaAttr    = lojaSlug ? `data-loja="${lojaSlug}"` : '';
        const ean         = mainProd.ean || '';

        const precosPorLoja = mainProd.precos || {};
        let valorBruto  = 0;
        let valorOferta = 0;

        if (isCampaignSection && mainProd._campaignData) {
            const camp = mainProd._campaignData;

            valorBruto  = Number(
                camp.preco != null
                    ? camp.preco
                    : (mainProd.valor ?? mainProd.preco ?? 0)
            );

            valorOferta = Number(
                camp.oferta != null
                    ? camp.oferta
                    : (mainProd.valor_promocional ?? valorBruto)
            );

        } else {
            // 🔹 Fluxo normal (não é campanha)
            const lojaKey = resolveLojaKey(precosPorLoja, lojaIdBruta);

            if (lojaSlug) {
                if (!lojaKey) continue; // não tem preço pra essa loja, pula

                const pLoja = precosPorLoja[lojaKey] || {};
                valorBruto  = Number(pLoja.valor  ?? mainProd.valor ?? 0);
                valorOferta = Number(pLoja.oferta ?? mainProd.valor_promocional ?? valorBruto);
            } else {
                valorBruto  = Number(mainProd.valor ?? mainProd.preco ?? 0);
                valorOferta = Number(mainProd.valor_promocional ?? valorBruto);
            }
        }

        const economia = Math.max(0, valorBruto - valorOferta);

        let precoHtml = '';
        if (valorBruto > 0 && valorOferta > 0 && valorOferta < valorBruto) {
            precoHtml = `
                <div class="precoOferta">
                    <del>R$ ${formatMoney(valorBruto)}</del>
                    <span>R$ ${formatMoney(valorOferta)}</span>
                </div>`;
        } else if (valorOferta > 0) {
            precoHtml = `
                <div class="precoOferta">
                    <span>R$ ${formatMoney(valorOferta)}</span>
                </div>`;
        }

        const isClube  = mainProd.clube;
        const isOferta = mainProd.oferta;
        let etiqueta = '';

        if (isClube) {
            etiqueta = "<div class='etiqueta clube'>Clube</div>";
        } else if (isOferta) {
            etiqueta = "<div class='etiqueta oferta'>Oferta</div>";
        }

        const unidadeMedida = mainProd.medida
            ? `(${mainProd.medida})`
            : '';

        const descricao   = mainProd.descricao || '';
        const inEcommerce = mainProd.ecommerce;
        let displayCart = '';
        
        if(ECOMMERCE_ACTIVE == 1){
            if (!inEcommerce) {
                displayCart = 'style="display:none;"';
            }
        }
        else{
            displayCart = 'style="display:none;"';
        }

        const exibirApp   =
            (mainProd.exibir === true || mainProd.exibir === 1 || mainProd.exibir === '1')
                ? 'true'
                : 'false';

        const limiteQtd     = Number(mainProd.limite ?? mainProd.limiteQtd ?? 0) || 999;
        const dataSmartAttr = idSmart ? `data-smart="${idSmart}"` : '';

        html += `
        <div class="col-lg-4 col-md-3 col-sm-6 col-6 individual"
             ${dataSmartAttr}
             data-id="${prodId}"
             ${lojaAttr}>
            <div class="blocoOfertaApp"
                 ${dataSmartAttr}
                 data-ecommerce="${inEcommerce ? '1' : '0'}"
                 data-familia="${familia ? familia : ''}"
                 data-exibir-app="${exibirApp}"
                 data-id="${prodId}"
                 data-ean="${ean}"
                 data-codigo-produto="${codigo}">`;

        if (economia > 0) {
            html += `<p class="economia">Economize R$ ${formatMoney(economia)}</p>`;
        }

        html += `
                <div class="imagemOferta editable-imagem">
                    <img 
                        src="${imagemProd}" 
                        alt="${tituloProd}"
                        onerror="this.onerror=null;this.src='${PLACEHOLDER_IMG}';"
                    >
                </div>
                <span class="aviso">*Imagem meramente ilustrativa</span>
                <p class="nomeOferta">${tituloProd} <span>${unidadeMedida}</span></p>
                ${etiqueta}
                ${precoHtml}
                <p class="descricaoOferta">${descricao}</p>
        `;

        // aqui você pode usar visibleProducts.length se quiser ser mais fiel
        if (familia && group.products.length > 1) {
            html += `
                <div class="section-family">
                    <button class="btn-familia see-family"
                            ${dataSmartAttr}
                            data-section="${id}"
                            data-familia="${familia}">
                        <i class="fa-solid fa-eye"></i> Ver Opções
                    </button>
                </div>
            `;
        } else {
            if (idSmart && limiteQtd !== 999) {
                html += `
                <div class="adicionar-carrinho" ${displayCart}>
                    <div class="quantidade">
                        <button class="btn-menos">-</button>
                        <input type="number" min="1" max="${limiteQtd}" value="1" class="input-quantidade" />
                        <button class="btn-mais">+</button>
                    </div>
                    <button class="btn-adicionar add-cart"
                            ${dataSmartAttr}
                            data-limite="${limiteQtd}"
                            data-id="${codigo}">
                        <i class="fa-solid fa-cart-shopping"></i> Comprar
                    </button>
                </div>
                <div class="quantidadeLimite text-center">
                    Apenas ${limiteQtd} unidades por pessoa
                </div>
                `;
            } else {
                html += `
                <div class="adicionar-carrinho" ${displayCart}>
                    <div class="quantidade">
                        <button class="btn-menos">-</button>
                        <input type="number" min="1" value="1" class="input-quantidade" />
                        <button class="btn-mais">+</button>
                    </div>
                    <button class="btn-adicionar add-cart"
                            ${dataSmartAttr}
                            data-id="${codigo}">
                        <i class="fa-solid fa-cart-shopping"></i> Comprar
                    </button>
                </div>
                `;
            }
        }
        
        html += `
            </div> <!-- .blocoOfertaApp -->
        </div> <!-- .individual -->
        `;

        rendered++;
    }


    html += `
        </div> <!-- .row / .carousel -->
    </div> <!-- .sectionContent -->
    `;

    return html;
}

function buildSectionCircleHtml(id, titulo, imagem, visibility) {
    // Ajustes especiais
    if (id == 'geral') {
        visibility = '1';
        imagem = logo;
    }

    if (!imagem) {
        imagem = logo;
    }

    return `
    <div class="sectionCircle text-center sortable-circles"
         data-id="${id}"
         data-visibility="${visibility}">
        <div class="circleWrapper">
            <button class="scroll-to-section" data-target="section-${id}">
                <img src="${imagem}" alt="${titulo}" class="img-fluid rounded-circle">
            </button>
        </div>
        <div class="sectionTitle mt-2">${titulo}</div>
    </div>
    `;
}

function buildFixedSections(products) {
    // sempre só products publish aqui
    const geral = products.filter(p =>
        p && p.status === 'publish' && p.exibir !== false
    );

    const ecommerce = products.filter(p =>
        p && p.status === 'publish' && p.ecommerce === true
    );

    const sections = [];

    if (geral.length) {
        sections.push({
            section: {
                id: 'geral',
                title: 'Geral',
                visibility: 1,
                format: 1,
                category: 0,
                type: 'fixed-geral',
                limit_show: 6   // 🔹 sempre 12
            },
            products: geral
        });
    }

    if (ecommerce.length && (ECOMMERCE_ACTIVE != 0 && ECOMMERCE_ACTIVE != 2)) {
        sections.push({
            section: {
                id: 'ecommerce',
                title: 'Ecommerce',
                visibility: 1,
                format: 1,
                category: 0,
                type: 'fixed-ecommerce',
                limit_show: 6   // 🔹 sempre 12
            },
            products: ecommerce
        });
    }

    return sections;
}

function activeSeeMore() {
    const botoes = document.querySelectorAll(".ver-mais-btn, .seta-btn, .seta-btn-grid");

    botoes.forEach(botao => {
        botao.addEventListener('click', function () {
            const idSection = this.getAttribute('data-section');
            document.getElementById('idSecaoAtual').value = idSection;

            document.querySelector('.filter__page').classList.add('actived');
            document.querySelector('body').classList.add('modal__actived'); 

            const toggleBtn = document.getElementById('toggleSelecionar');
            if (toggleBtn) {
                toggleBtn.textContent = 'Selecionar Tudo';
            }

            const lista = document.getElementById('listaProdutos');
            mostrarSkeletonProdutos(lista);
            searchInputModal.disabled = true;
            abrirModalDisable();

            // ✅ espera montar o HTML primeiro
            buildSectionsForStore(idSection);

        });
    });
}

function getInfoProducts(offers, isCampaign = false, campaignId = null) {
    const allProducts = getStoredProducts() || [];
    let codes = parseOfferCodes(offers); // já vem na ordem certa (do offers)

    if (!allProducts.length) return [];

    // 🔹 Dados da campanha (quando for seção de campanha)
    let campaignMap = null; // { codigo: {preco, oferta, limite, ...} }

    if (isCampaign && campaignId) {
        const allCampaigns = getStoredCampaign() || [];
        const camp = allCampaigns.find(c => String(c.id) === String(campaignId));

        if (camp && camp.conteudo) {
            try {
                const conteudoArr = JSON.parse(camp.conteudo); // array de itens da campanha
                const map = {};
                const campaignCodes = [];

                const flatten = arr => arr.reduce(
                    (acc, v) => acc.concat(Array.isArray(v) ? flatten(v) : v),
                    []
                );

                conteudoArr.forEach(rawItem => {
                    if (!rawItem) return;

                    // 👉 passa SEMPRE pelo enriquecimento de tags
                    const item = enrichCampaignItem(rawItem);

                    // ---- PÚBLICO-ALVO (vem de item.cliente) ----
                    let publico = [];
                    if (item.cliente) {
                        let arr = Array.isArray(item.cliente) ? item.cliente : [item.cliente];
                        const flat = flatten(arr);

                        publico = flat
                            .filter(c => c && (c.nome || c.name))
                            .map(c => ({
                                id: c.id ?? c.ID ?? null,
                                nome: String(c.nome || c.name).trim()
                            }));
                    }
                    if (publico.length) {
                        item.publico = publico;
                    }

                    // ---- CLIENTES EXCLUSIVOS (vem de item.cliente_exclusivo) ----
                    let exclusivos = [];
                    if (item.cliente_exclusivo) {
                        let arr = Array.isArray(item.cliente_exclusivo)
                            ? item.cliente_exclusivo
                            : [item.cliente_exclusivo];
                        const flat = flatten(arr);

                        exclusivos = flat
                            .filter(c => c && (c.nome || c.name))
                            .map(c => ({
                                id: c.id ?? c.ID ?? null,
                                nome: String(c.nome || c.name).trim()
                            }));
                    }
                    if (exclusivos.length) {
                        item.exclusivos = exclusivos;
                        item.hasClienteExclusivo = true;
                    } else {
                        item.hasClienteExclusivo = false;
                    }

                    const cod = String(item.codigo || item.code || '').trim();
                    if (!cod) return;

                    campaignCodes.push(cod);
                    map[cod] = item;
                });

                if (campaignCodes.length) {
                    if (!codes.length) {
                        codes = campaignCodes;
                    } else {
                        const setCamp = new Set(campaignCodes);
                        codes = codes.filter(c => setCamp.has(String(c)));
                    }
                    campaignMap = map;
                }
            } catch (e) {
                console.error('Erro ao fazer parse do conteudo da campanha:', e);
            }
        }
    }

    if (!codes.length) return [];

    // 🔹 Monta um mapa de produtos por código, já filtrando por status
    const mapProdutos = new Map();

    for (const prod of allProducts) {
        if (!prod) continue;

        const status = prod.status || 'publish';

        if (!isCampaign) {
            // Seção normal → SOMENTE publish
            if (status !== 'publish') continue;
        } else {
            // Campanha → publish OU draft
            if (status !== 'publish' && status !== 'draft') continue;
        }

        const codigo = prod.codigo != null ? String(prod.codigo) : '';
        if (!codigo) continue;

        if (!mapProdutos.has(codigo)) {
            mapProdutos.set(codigo, prod);
        }
    }

    // 🔹 Monta o array final na ORDEM dos codes
    const resultado = [];
    const usados = new Set();

    for (const code of codes) {
        const c = String(code);
        const baseProd = mapProdutos.get(c);
        if (!baseProd || usados.has(c)) continue;

        let prodFinal = baseProd;

        if (isCampaign && campaignMap && campaignMap[c]) {
            const campItem = campaignMap[c];

            prodFinal = {
                ...baseProd,
                valor: campItem.preco != null ? Number(campItem.preco) : baseProd.valor,
                valor_promocional: campItem.oferta != null ? Number(campItem.oferta) : (baseProd.valor_promocional ?? baseProd.valor),
                limiteQtd: campItem.limite != null ? Number(campItem.limite) : (baseProd.limiteQtd ?? baseProd.limite),
                limite: campItem.limite != null ? Number(campItem.limite) : baseProd.limite,
                _campaignData: campItem
            };
        }

        resultado.push(prodFinal);
        usados.add(c);
    }

    return resultado;
}

function load_family_products(idFamily, campaignId = null) {
    const productsContainer = document.getElementById('listaProdutos');
    if (!productsContainer) return;

    const allProducts = getStoredProducts() || [];
    if (!allProducts.length) {
        productsContainer.innerHTML = `
            <div class="no-offers my-5">
                <div class="no-offers-card">
                    <div class="no-offers-icon">
                        <i class="fa-solid fa-cart-shopping"></i>
                    </div>
                    <h2 class="no-offers-title">Sem produtos para essa família</h2>
                </div>
            </div>
        `;
        return;
    }

    // 1) Filtra só produtos da família clicada
    let familyProductsRaw = allProducts.filter(prod => {
        if (!prod) return false;
        return String(prod.familia || '') === String(idFamily);
    });

    if (!familyProductsRaw.length) {
        productsContainer.innerHTML = `
            <div class="no-offers my-5">
                <div class="no-offers-card">
                    <div class="no-offers-icon">
                        <i class="fa-solid fa-cart-shopping"></i>
                    </div>
                    <h2 class="no-offers-title">Nenhuma opção encontrada para essa família</h2>
                </div>
            </div>
        `;
        return;
    }

    // 2) Se vier de campanha, sobrescreve preços/limite + público-alvo / exclusivos pelos dados da campanha
    if (campaignId) {
        const allCampaigns = getStoredCampaign() || [];
        const camp = allCampaigns.find(c => String(c.id) === String(campaignId));

        if (camp && camp.conteudo) {
            try {
                const conteudoArr = JSON.parse(camp.conteudo); // array de itens da campanha
                const campMap = {}; // { codigo: itemCamp }

                const flatten = arr => arr.reduce(
                    (acc, v) => acc.concat(Array.isArray(v) ? flatten(v) : v),
                    []
                );

                conteudoArr.forEach(rawItem => {
                    if (!rawItem) return;

                    const item = { ...rawItem };

                    // ------------ PÚBLICO-ALVO (item.cliente) ------------
                    let publico = [];
                    if (item.cliente) {
                        let arr = Array.isArray(item.cliente) ? item.cliente : [item.cliente];
                        const flat = flatten(arr);

                        publico = flat
                            .filter(c => c && (c.nome || c.name))
                            .map(c => ({
                                id: c.id ?? c.ID ?? null,
                                nome: String(c.nome || c.name).trim()
                            }));
                    }
                    if (publico.length) {
                        item.publico = publico;
                    }

                    // ------------ CLIENTES EXCLUSIVOS (item.cliente_exclusivo) ------------
                    let exclusivos = [];
                    if (item.cliente_exclusivo) {
                        let arr = Array.isArray(item.cliente_exclusivo)
                            ? item.cliente_exclusivo
                            : [item.cliente_exclusivo];
                        const flat = flatten(arr);

                        exclusivos = flat
                            .filter(c => c && (c.nome || c.name))
                            .map(c => ({
                                id: c.id ?? c.ID ?? null,
                                nome: String(c.nome || c.name).trim()
                            }));
                    }
                    if (exclusivos.length) {
                        item.exclusivos = exclusivos;
                        item.hasClienteExclusivo = true;
                    } else {
                        item.hasClienteExclusivo = false;
                    }

                    // ------------ CÓDIGO DO PRODUTO ------------
                    const cod = String(item.codigo || item.code || '').trim();
                    if (!cod) return;

                    campMap[cod] = item;
                });

                // aplica nos produtos da família
                familyProductsRaw = familyProductsRaw.map(prod => {
                    const cod = String(prod.codigo || '');
                    const itemCamp = campMap[cod];

                    if (!itemCamp) return prod; // não está na campanha

                    return {
                        ...prod,
                        valor: itemCamp.preco != null
                            ? Number(itemCamp.preco)
                            : (prod.valor ?? prod.preco ?? 0),
                        valor_promocional: itemCamp.oferta != null
                            ? Number(itemCamp.oferta)
                            : (prod.valor_promocional ?? prod.valor ?? prod.preco ?? 0),
                        limiteQtd: itemCamp.limite != null
                            ? Number(itemCamp.limite)
                            : (prod.limiteQtd ?? prod.limite),
                        limite: itemCamp.limite != null
                            ? Number(itemCamp.limite)
                            : prod.limite,
                        _campaignData: itemCamp // ← inclui publico, exclusivos, hasClienteExclusivo
                    };
                });

                // 🔹 FILTRO POR CLIENTE EXCLUSIVO / TAG (usa mesma função da listagem normal)
                familyProductsRaw = familyProductsRaw.filter(prod => {
                    // se não é produto da campanha (sem _campaignData), deixa passar
                    if (!prod._campaignData) return true;
                    return canShowCampaignProductForUser(prod);
                });

            } catch (e) {
                console.error('Erro ao parsear conteúdo da campanha na família:', e);
            }
        }
    }

    // Se depois do filtro não sobrou nada, mostra mensagem
    if (!familyProductsRaw.length) {
        productsContainer.innerHTML = `
            <div class="no-offers my-5">
                <div class="no-offers-card">
                    <div class="no-offers-icon">
                        <i class="fa-solid fa-cart-shopping"></i>
                    </div>
                    <h2 class="no-offers-title">Nenhuma opção disponível para você nessa família</h2>
                </div>
            </div>
        `;
        return;
    }

    // 3) Evitar que o groupProductsByFamily agrupe tudo num card só
    const familyProducts = familyProductsRaw.map((prod, index) => ({
        ...prod,
        familia: `${prod.familia || idFamily}-${index}` // cada produto vira “sua própria família”
    }));

    // 4) Section fake só para o modal de família
    const fakeSection = {
        id: `family-${idFamily}`,
        title: 'Escolha a opção desejada',
        visibility: 1,
        format: 1,
        category: 0,
        id_smart_campaign: campaignId ? Number(campaignId) : 0,
        data_start: '0000-00-00 00:00:00',
        data_end:   '0000-00-00 00:00:00'
    };

    // 5) Reaproveita a mesma lógica de montagem
    const html = buildSectionProductsHtml(fakeSection, familyProducts, true);
    productsContainer.innerHTML = html;
}


function waitForElement(selector, timeout = 2000) {
  return new Promise((resolve) => {
    const el = document.querySelector(selector);
    if (el) return resolve(el);

    const obs = new MutationObserver(() => {
      const found = document.querySelector(selector);
      if (found) {
        obs.disconnect();
        resolve(found);
      }
    });

    obs.observe(document.documentElement, { childList: true, subtree: true });

    setTimeout(() => {
      obs.disconnect();
      resolve(document.querySelector(selector)); // pode ser null
    }, timeout);
  });
}

function normalizeCampaignId(raw) {
  const s = (raw ?? "").toString().trim();
  if (!s || s === "0" || s === "null" || s === "undefined") return null;
  const n = Number(s);
  return Number.isFinite(n) ? n : null;
}

async function openFamilyOptions(idFamily, smartIdRaw) {
  const fam = (idFamily ?? "").toString().trim();
  if (!fam) return;

  const campaignId = normalizeCampaignId(smartIdRaw);

  // fecha modal do produto
  $("#modalProduto").removeClass("open");

  // abre tela da família
  document.querySelector(".filter__page")?.classList.add("actived");
  document.querySelector("body")?.classList.add("modal__actived");

  // espera o container existir
  const container = await waitForElement("#listaProdutos", 2000);

  if (!container) {
    console.warn("❌ #listaProdutos NÃO existe no DOM. load_family_products vai dar return.");
    Swal?.fire?.({
      icon: "warning",
      title: "Não foi possível abrir as opções",
      text: "O container #listaProdutos não foi encontrado nessa tela."
    });
    return;
  }

  load_family_products(fam, campaignId);
}

document.addEventListener('click', function (e) {
  const btn = e.target.closest('.see-family');
  if (!btn) return;

  // roda antes de qualquer listener que dê stopPropagation
  e.preventDefault();
  e.stopPropagation();
  e.stopImmediatePropagation();

  const idFamily = (btn.getAttribute('data-familia') || '').trim();
  const smartId  = (btn.getAttribute('data-smart') || '').trim();

  openFamilyOptions(idFamily, smartId);
}, true); // ✅ CAPTURE = true


document.addEventListener('click', function (e) {
  const btnMais  = e.target.closest('.btn-mais');
  const btnMenos = e.target.closest('.btn-menos');
  if (!btnMais && !btnMenos) return;

  e.preventDefault();
  e.stopPropagation();
  e.stopImmediatePropagation();

  const wrap = (btnMais || btnMenos).closest('.quantidade');
  if (!wrap) return;

  const input = wrap.querySelector('.input-quantidade');
  if (!input) return;

  let atual = parseInt(input.value, 10);
  if (!Number.isFinite(atual) || atual < 1) atual = 1;

  const max = parseInt(input.getAttribute('max'), 10) || 999;

  if (btnMais && atual < max) input.value = atual + 1;
  if (btnMenos && atual > 1) input.value = atual - 1;

  input.dispatchEvent(new Event('change', { bubbles: true }));
}, true); // ✅ CAPTURE
