const andress = $('#andress-list');
const NewAndress = $('#new-address');
let ultimoEnderecoSelecionado = '1';

// chave do localStorage
let LS_KEY = 'endereco_salvo';

// troca de abas
document.querySelectorAll('.tab-item').forEach(item=>{
    item.addEventListener('click', ()=>{
        const target = item.dataset.tabContent;

        // header
        document.querySelectorAll('.tab-item').forEach(i=>{
            i.classList.toggle('active', i===item);
            i.setAttribute('aria-selected', i===item ? 'true' : 'false');
        });

        // conteúdo
        document.querySelectorAll('.tab-content').forEach(el=>{
            el.classList.toggle('active', el.id === target);
        });
    });
});

// Formas para atualizar, trocar senha, etc...
$(document).ready(function () {
    $('.modal#change-password .formPassword').on('submit', function (e) {

        e.preventDefault();

        $('.modal#change-password').removeClass('message_1 message_2 message_3');
        var var_form_data = $(this).serialize();

        $.ajax({
            type: "POST",
            url: "/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-change-password.php",
            data: var_form_data,
            success: function (retorno) {
                if (retorno == 1) {
                    $('.modal#change-password.formPassword').addClass('message_1');

                    Swal.fire({
                        icon: 'success',
                        title: 'Senha alterada com sucesso!',
                        timer: 2000,
                        showConfirmButton: false
                    });

                    setTimeout(function () {
                        $('#change-password .formPassword').removeClass('open');
                    }, 2000);

                } else if (retorno == 2) {
                    $('.modal#change-password .formPassword').addClass('message_2');

                    Swal.fire({
                        icon: 'error',
                        title: 'Erro',
                        text: 'As novas senhas não coincidem.'
                    });

                } else {
                    $('.modal#change-password .formPassword').addClass('message_3');

                    Swal.fire({
                        icon: 'error',
                        title: 'Senha atual incorreta!',
                        text: 'Por favor, verifique sua senha atual.'
                    });
                }
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: 'Erro de conexão',
                    text: 'Não foi possível alterar a senha. Tente novamente.'
                });
            }
        });
    });

    $('.btn-error').on('click', function (e) {
        e.preventDefault();
        Swal.fire({
            title: 'Você tem certeza?',
            text: 'Você não terá mais acesso às nossas ofertas especiais 😢',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sim, prosseguir',
            cancelButtonText: 'Cancelar',
            confirmButtonColor: '#e74c3c',
            cancelButtonColor: '#2ecc71'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Confirmação',
                    input: 'text',
                    inputLabel: 'Digite: deletar',
                    inputPlaceholder: 'deletar',
                    inputValidator: (value) => {
                        if (value !== 'deletar') {
                            return 'A frase exata precisa ser digitada!';
                        }
                    },
                    showCancelButton: true,
                    confirmButtonText: 'Confirmar frase',
                    cancelButtonText: 'Cancelar',
                    confirmButtonColor: '#e67e22'
                }).then((result) => {
                    if (result.isConfirmed) {
                        Swal.fire({
                            title: 'Digite sua senha',
                            input: 'password',
                            inputPlaceholder: '********',
                            inputAttributes: {
                                minlength: 6,
                                required: true
                            },
                            showCancelButton: true,
                            confirmButtonText: 'Deletar conta',
                            cancelButtonText: 'Cancelar',
                            confirmButtonColor: '#c0392b'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                const senha = result.value;

                                $.ajax({
                                    type: 'POST',
                                    url: '/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-disabled-account.php',
                                    data: { senhaDisabled: senha },
                                    success: function (retorno) {
                                        if (retorno == 1) {
                                            Swal.fire({
                                                icon: 'success',
                                                title: 'Conta desativada!',
                                                text: 'Você será desconectado em 10 segundos...',
                                                timer: 10000,
                                                timerProgressBar: true,
                                                showConfirmButton: false
                                            });

                                            setTimeout(function () {
                                                window.location.href = "<?= home_url(); ?>";
                                            }, 10000);
                                        } else {
                                            Swal.fire({
                                                icon: 'error',
                                                title: 'Senha incorreta!',
                                                text: 'Tente novamente ou cancele a operação.'
                                            });
                                        }
                                    },
                                    error: function () {
                                        Swal.fire({
                                            icon: 'error',
                                            title: 'Erro',
                                            text: 'Ocorreu um erro ao processar sua solicitação.'
                                        });
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    });

    $('form.formDisabledAcount').on('submit', function (e) {
        e.preventDefault();
        $.ajax({
            type: "POST",
            url: "/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-disabled-account.php",
            data: var_form_data,
            success: function(retorno){
                if(retorno == 1){
                    $('#step-4').removeClass('show');
                    $('#step-5').addClass('show');
                    setTimeout(function(){
                        window.location.href = "<?= home_url(); ?>";
                    }, 10000);
                }else{
                    Swal.fire({
                    icon: 'error',
                    title: 'Erro ao atualizar perfil',
                    text:'Senha incorreta'
                });
                }
            }
        });
    });

    document.getElementById('atualizarPerfil').addEventListener('submit', function(e) {
        e.preventDefault();
        const nascimentoInput = document.querySelector('input[name="nascimento"]');
        if (nascimentoInput && nascimentoInput.value.includes('/')) {
            const [dia, mes, ano] = nascimentoInput.value.split('/');
            nascimentoInput.value = `${ano}-${mes}-${dia}`;
        }
        var formData = new FormData(this);
    
        $.ajax({
            type: 'POST',
            url: '/wp-content/themes/app/mobile-view/server-side/access-control/logged-in/server-processing-change-profile.php',
            data: formData,
            processData: false,
            contentType: false,
            // dica: se puder, force o jQuery a parsear pra você:
            // dataType: 'json',
            success: function (resp, _status, xhr) {
                // se usou dataType:'json', resp já é objeto
                var response = safeParseJSON(resp);

                if (!response) {
                // tenta ainda extrair do responseText (erros PHP/HTML)
                var raw = (xhr && xhr.responseText) ? xhr.responseText.trim() : '';
                console.error('Resposta inválida do servidor:', raw);
                Swal.fire({
                    icon: 'error',
                    title: 'Erro ao atualizar perfil',
                    text: 'Resposta inválida do servidor.'
                });
                return;
                }

                if (response.error) {
                $('.modal#change-password #atualizarPerfil').addClass('message_2');
                Swal.fire({
                    icon: 'error',
                    title: 'Erro ao atualizar perfil',
                    text: 'Houve algum erro ao atualizar o cadastro. Por favor, tente novamente.'
                });
                } else {
                var successMessage = (response.success || 'Cadastro atualizado com sucesso!').toString();
                $('.modal#change-password #atualizarPerfil').addClass('message_1');
                Swal.fire({
                    icon: 'success',
                    title: 'Perfil atualizado!',
                    text: successMessage,
                    timer: 2000,
                    showConfirmButton: false
                });
                setTimeout(function () { $('#change-password').removeClass('open'); }, 2000);
                }
            },
            error: function (xhr) {
                const txt = (xhr.responseText || '').trim();
                console.error('Erro AJAX', xhr.status, txt);
                Swal.fire({
                icon: 'error',
                title: 'Erro de conexão',
                text: 'Houve um erro ao atualizar o cadastro. Por favor, tente novamente.'
                });
            }
        });

    });
    
});

// Sair das Ofertas
function confirmarSaida() {
    Swal.fire({
        title: 'Confirmação',
        text: 'Tem certeza que deseja sair?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Confirmar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Aqui executa o AJAX que estava no botão
            $.ajax({
                type: "POST",
                url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-logout.php",
                success: function(){
                window.location.href = '/';
                }
            });
        }
    });
}

// Listener delegado: funciona para radios que entram depois via AJAX
$(document).on('change', 'input[name="opcao-endereco"]', function () {
    const valor = $('input[name="opcao-endereco"]:checked').val();

    if (valor === '1') {
        // usar endereço cadastrado
        NewAndress.stop(true, true).fadeOut(360, function () {
            andress.fadeIn(360);
        });
    } else if (valor === 'new') {
        // inserir novo
        andress.stop(true, true).fadeOut(360, function () {
            NewAndress.fadeIn(360, function () {
                if (window.map) map.invalidateSize();
            });
        });
    } else {
        // um endereço dos cards anteriores
        NewAndress.stop(true, true).fadeOut(360, function () {
            andress.fadeIn(360);
        });
    }
});

// Estado inicial ao carregar a página
$(function () {
    const inicial = $('input[name="opcao-endereco"]:checked').val();
    if (inicial === 'new') {
        andress.hide();
        NewAndress.show();
        if (window.map) map.invalidateSize();
    } else {
        // default: lista visível, form oculto
        NewAndress.hide();
        andress.show();
    }
});

// Listener delegado para mudar endereço
$(document).on('change', 'input[name="opcao-endereco"]', function () {
    const valor = $('input[name="opcao-endereco"]:checked').val();

    if (valor !== 'new') {
        // guarda o último que não seja "novo"
        ultimoEnderecoSelecionado = valor;
    }

    if (valor === '1') {
        NewAndress.stop(true, true).fadeOut(360, function () {
        andress.fadeIn(360);
        });
    } else if (valor === 'new') {
            andress.stop(true, true).fadeOut(360, function () {
                NewAndress.fadeIn(360, function () {
                if (window.map) map.invalidateSize();
            });
        });
    } else {
        NewAndress.stop(true, true).fadeOut(360, function () {
            andress.fadeIn(360);
        });
    }
});

// Botão "Voltar"
$(document).on('click', '.btn-address[type="button"]', function () {
    $('input[name="opcao-endereco"][value="'+ultimoEnderecoSelecionado+'"]')
    .prop('checked', true)
    .trigger('change');
});

// normaliza chave única para comparar/selecionar
function addressKey(a) {
    const norm = (v) => (v === undefined || v === null) ? '' : String(v).trim().toUpperCase();
    return [
        norm(a.cep),
        norm(a.cidade),
        norm(a.estado),
        norm(a.bairro),
        norm(a.rua),
        norm(a.numero)
    ].join('|');
}

// cria um card DOM a partir de um objeto endereço
function buildAddressCard(addr) {
    const linha1 = [addr.rua, addr.numero].filter(Boolean).join(' - ');
    const linha2 = [
        addr.bairro ? `${addr.bairro}, ` : '',
        addr.cidade || '',
        addr.estado ? ` - ${addr.estado}` : ''
    ].join('');
    const resumo = [linha1, linha2, addr.cep].filter(Boolean).join(' , ');

    const $wrap = $('<div class="lista-pagamentos"></div>');
    const $label = $('<label class="opcao-pagamento"></label>').appendTo($wrap);
    const $input = $('<input type="radio" name="opcao-endereco">')
        .val(String(addr.value ?? ''))
        .attr('data-cep', addr.cep || '')
        .attr('data-cidade', addr.cidade || '')
        .attr('data-estado', addr.estado || '')
        .attr('data-bairro', addr.bairro || '')
        .attr('data-rua', addr.rua || '')
        .attr('data-numero', addr.numero || '')
        .attr('data-complemento', addr.complemento || '')
        .attr('data-lat', addr.lat || '')
        .attr('data-lng', addr.lng || '')
        .attr('data-data', addr.data || '');

    if (addr.checked) $input.prop('checked', true);

    const $span = $('<span><i class="fa-solid fa-location-dot"></i> '+ linha1 +'</span>');
    const $small = $('<small></small>').text(resumo);

    $label.append($input, $span, $small);
    return $wrap;
}

// aplica um objeto "data" de radio nos campos do formulário
function fillFormFromData(data) {
    $('#cepEntrega').val(data.cep || '');
    $('#cidadeEntrega').val(data.cidade || '');
    $('#estadoEntrega').val(data.estado || '');
    $('#bairroEntrega').val(data.bairro || '');
    $('#ruaEntrega').val(data.rua || '');
    $('#numeroEntrega').val(data.numero || '');
    $('#complemento').val(data.complemento || '');
    if (data.lat && data.lng && window.atualizarMapa) {
        const lat = parseFloat(data.lat), lng = parseFloat(data.lng);
        if (!Number.isNaN(lat) && !Number.isNaN(lng)) atualizarMapa(lat, lng, false);
    }
}

// salva no localStorage
function saveSelectedToLS($radio) {
    const d = $radio.data();
    const payload = {
        source: $radio.val()==='1' ? 'cadastrado' : 'card',
        cep: d.cep || '', cidade: d.cidade || '', estado: d.estado || '',
        bairro: d.bairro || '', rua: d.rua || '', numero: d.numero || '',
        complemento: d.complemento || '', lat: d.lat || '', lng: d.lng || '',
        data: d.data || '', value: String($radio.val() || '')
    };
    localStorage.setItem(LS_KEY, JSON.stringify(payload));
}

// listar endereços
async function listarEnderecos() {

    try {

        const res = await fetch('/wp-content/themes/app/mobile-view/server-side/offer-control/server-processing-ecommerce.php',{
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'listar_enderecos', id: idUsuario })
        });

        const payload = await res.json();

        if (!payload.success) {
            Swal.fire('Erro', payload.message || 'Falha ao listar endereços.', 'error');
            return;
        }

        $('#andress-card').html(payload.data || '');

        let saved = null;
        let injetouDoLS = false;
        
        try {
            const raw = localStorage.getItem(LS_KEY);
            if (raw) saved = JSON.parse(raw);
        } catch(_) {}

        if (saved && saved.source === 'card') {

            const keyWanted = addressKey(saved);
            let exists = false;
            $('#andress-card input[name="opcao-endereco"]').each(function(){
                const d = $(this).data();
                const k = addressKey(d);
                if (k === keyWanted || String($(this).val()) === String(saved.value)) {
                    exists = true; return false;
                }
            });

            if (!exists) {
                const $card = buildAddressCard({
                cep: saved.cep || '', cidade: saved.cidade || '', estado: saved.estado || '',
                bairro: saved.bairro || '', rua: saved.rua || '', numero: saved.numero || '',
                complemento: saved.complemento || '', lat: saved.lat || '', lng: saved.lng || '',
                data: saved.data || '', value: saved.value || ('temp_'+Date.now()),
                checked: true // já marcar como selecionado
                });
                $('#andress-card').prepend($card);
                injetouDoLS = true;
            }
        }

        $('input[name="opcao-endereco"]').off('change').on('change', function(){
            const $sel = $('input[name="opcao-endereco"]:checked');
            const valor = $sel.val();

            if (valor === '2' || valor === 'new') {
                // inserir novo
                $('#andress-list').stop(true,true).fadeOut(150, ()=>$('#new-address').fadeIn(150, ()=>{ if (window.map) map.invalidateSize(); }));
                return;
            }

            // usar cadastrado (valor === '1') OU um card
            $('#new-address').stop(true,true).fadeOut(150, ()=>$('#andress-list').fadeIn(150));

            const data = $sel.data();
            if (data && data.rua) {
                $('#cepEntrega').val(data.cep || '');
                $('#cidadeEntrega').val(data.cidade || '');
                $('#estadoEntrega').val(data.estado || '');
                $('#bairroEntrega').val(data.bairro || '');
                $('#ruaEntrega').val(data.rua || '');
                $('#numeroEntrega').val(data.numero || '');
                $('#complemento').val(data.complemento || '');
                if (data.lat && data.lng && window.atualizarMapa) {
                atualizarMapa(parseFloat(data.lat), parseFloat(data.lng), false);
                }
            }

            // salva a seleção no LS (sem mudar cadastro do usuário)
            try {
                const d = $sel.data();
                const payloadLS = {
                source: ($sel.val()==='1') ? 'cadastrado' : 'card',
                cep: d.cep || '', cidade: d.cidade || '', estado: d.estado || '',
                bairro: d.bairro || '', rua: d.rua || '', numero: d.numero || '',
                complemento: d.complemento || '', lat: d.lat || '', lng: d.lng || '',
                data: d.data || '', value: String($sel.val() || '')
                };
                localStorage.setItem(LS_KEY, JSON.stringify(payloadLS));
            } catch(_) {}
        });

        const $all = $('input[name="opcao-endereco"]');
        const $cards = $('#andress-card input[name="opcao-endereco"]');
        const $recentChecked = $('#andress-card input[name="opcao-endereco"]:checked');

        if (injetouDoLS && saved) {
            $all.prop('checked', false);
            const $byVal = $(`#andress-card input[name="opcao-endereco"][value="${saved.value}"]`);
            if ($byVal.length) {
                $byVal.prop('checked', true).trigger('change');
            } else if ($cards.length) {
                $cards.first().prop('checked', true).trigger('change');
            } else {
                $('input[name="opcao-endereco"][value="1"]').prop('checked', true).trigger('change');
            }
        } else if ($recentChecked.length) {
            $all.prop('checked', false);
            $recentChecked.prop('checked', true).trigger('change');
        } else if ($cards.length) {
            $all.prop('checked', false);
            $cards.first().prop('checked', true).trigger('change');
        } else {
            $all.prop('checked', false);
            $('input[name="opcao-endereco"][value="1"]').prop('checked', true).trigger('change');
        }

    } catch (e) {
        console.error(e);
        Swal.fire('Erro', 'Falha na comunicação com o servidor.', 'error');
    }
}

// tenta restaurar seleção do LS
function tryRestoreSelectionFromLS() {
    const raw = localStorage.getItem(LS_KEY);
    if (!raw) return false;
    try {
        const saved = JSON.parse(raw);
        // tenta pelo value primeiro
        if (saved.value) {
            const $byVal = $(`input[name="opcao-endereco"][value="${saved.value}"]`);
            if ($byVal.length) {
                $(`input[name="opcao-endereco"]`).prop('checked', false);
                $byVal.prop('checked', true).trigger('change');
                return true;
            }
        }
        // tenta por chave de endereço
        const keyWanted = addressKey(saved);
        let found = false;
        $('#andress-card input[name="opcao-endereco"]').each(function(){
            const d = $(this).data();
            const k = addressKey(d);
            if (k === keyWanted) {
                $(`input[name="opcao-endereco"]`).prop('checked', false);
                $(this).prop('checked', true).trigger('change');
                found = true;
                return false;
            }
        });
        if (found) return true;

        // se for cadastrado
        if (saved.source === 'cadastrado') {
            const $cad = $('input[name="opcao-endereco"][value="1"]');
            if ($cad.length) {
                $(`input[name="opcao-endereco"]`).prop('checked', false);
                $cad.prop('checked', true).trigger('change');
                return true;
            }
        }
    } catch(e){}
    return false;
}

listarEnderecos();

// Adicionar endereço
document.getElementById('form-entrega').addEventListener('submit', function(e) {
    e.preventDefault();

    const cep    = $('#cepEntrega').val()      || '';
    const cidade = $('#cidadeEntrega').val()   || '';
    const estado = $('#estadoEntrega').val()   || '';
    const bairro = $('#bairroEntrega').val()   || '';
    const rua    = $('#ruaEntrega').val()      || '';
    const numero = $('#numeroEntrega').val()   || '';
    const comp   = $('#complemento').val()     || '';
    const lat    = $('#formLatitude').val()    || '';
    const lng    = $('#formLongitude').val()   || '';
    const data   = new Date().toISOString().slice(0,19).replace('T',' ');

    const linha1 = [rua, numero].filter(Boolean).join(' - ');
    const linha2 = `${bairro ? bairro+', ' : ''}${cidade}${estado ? ' - '+estado : ''}`;
    const resumo = [linha1, linha2, cep].filter(Boolean).join(' , ');

    const value = 'temp_' + Date.now(); 

    const $wrap  = $('<div class="lista-pagamentos"></div>');
    const $label = $('<label class="opcao-pagamento"></label>').appendTo($wrap);
    const $radio = $('<input type="radio" name="opcao-endereco">')
        .val(value)
        .attr('data-cep', cep)
        .attr('data-cidade', cidade)
        .attr('data-estado', estado)
        .attr('data-bairro', bairro)
        .attr('data-rua', rua)
        .attr('data-numero', numero)
        .attr('data-complemento', comp)
        .attr('data-lat', lat)
        .attr('data-lng', lng)
        .attr('data-data', data)
        .prop('checked', true);

    const $span  = $('<span><i class="fa-solid fa-location-dot"></i> '+ linha1 +'</span>');
    const $small = $('<small></small>').text(resumo);

    $label.append($radio, $span, $small);

    $('#andress-card').prepend($wrap);
    $('input[name="opcao-endereco"]').not($radio).prop('checked', false);
    $radio.trigger('change');

    try {
        const payload = {
            source: 'card',
            cep, cidade, estado, bairro, rua, numero, complemento: comp, lat, lng, data,
            value
        };
        localStorage.setItem('endereco_salvo', JSON.stringify(payload));
    } catch(_) {}

    Swal.fire('Pronto!', 'Endereço adicionado à lista.', 'success');
    $('#complemento').val('');
});

// util opcional
function safeParseJSON(x) {
  if (x == null) return null;
  if (typeof x !== 'string') return x;         // já é objeto
  const t = x.trim();
  if (!t) return null;                          // vazio
  try { return JSON.parse(t); } catch { return null; }
}
