$(function() {
    const path = window.location.pathname;
    const isOfertas = (path === '/ofertas/' || path === '/ofertas');

    if (!isOfertas) return;

    $(window).on('load', function() {
        $('#pageLoader').fadeOut();
    });

    $(window).on('beforeunload', function() {
        $('.modal').removeClass('open');
        $('#pageLoader').fadeIn(500);
    });
});


function initAuthEvents() {

    $('.date').mask('00/00/0000');
    $('.time').mask('00:00:00');
    $('.date_time').mask('00/00/0000 00:00:00');
    $('.cep').mask('00000-000');
    $('.phone').mask('0000-0000');
    $('.phone_with_ddd').mask('(00) 00000-0000');
    $('.cpf').mask('000.000.000-00', {reverse: true});
    $('.money').mask('000.000.000.000.000,00', {reverse: true});
    $(".birthdate").mask("99/99/9999");
    $('.placeholder').mask("00/00/0000", {placeholder: "__/__/____"});
    $('.selectonfocus').mask("00/00/0000", {selectOnFocus: true});

    $(".eye").click(function() {
        $(".eye i").toggleClass("fa-eye fa-eye-slash");
        var input = $("#password");
        if (input.attr("type") == "password") {
            input.attr("type", "text");
        } else {
            input.attr("type", "password");
        }
    });

    function limpa_formulário_cep() {
        // Limpa valores do formulário de cep.
        $("#rua").val("");
        $("#bairro").val("");
        $("#cidade").val("");
        $("#uf").val("");
    }

    // Função para remover acentos e padronizar o texto para comparação
    function normalizeText(text) {
        return text
        .normalize("NFD") // Separa caracteres acentuados
        .replace(/[\u0300-\u036f]/g, "") // Remove acentos
        .replace(/['"]/g, "") // Remove aspas simples e duplas
        .toLowerCase() // Converte para minúsculas
        .replace(/\s+/g, ' ') // Remove espaços extras
        .trim(); // Remove espaços desnecessários
    }

    // Quando o campo CEP perde o foco.
    $("#cep").blur(function () {
        var cep = $(this).val().replace(/\D/g, '');

        if (cep != "") {
            var validacep = /^[0-9]{8}$/;

            if (validacep.test(cep)) {
                $("#rua").val("");
                $("#bairro").val("");
                $("#cidade").val("").trigger("change");
                $("#uf").val("");

                $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {
                    if (!("erro" in dados)) {
                        if (dados.logradouro) $("#rua").val(dados.logradouro);
                        if (dados.bairro) $("#bairro").val(dados.bairro);
                        if (dados.uf) $("#uf").val(dados.uf);

                        let cidadeNormalizada = normalizeText(dados.localidade);
                        // console.log(cidadeNormalizada);

                        // Seleciona automaticamente a cidade no SELECT com base no nome tratado
                        $("#cidade option").each(function () {
                            if (normalizeText($(this).text()) === cidadeNormalizada) {
                                $(this).prop("selected", true).trigger("change");
                            }
                        });

                    } else {
                        limpa_formulário_cep();
                        Swal.fire({
							icon: 'error',
							title: 'CEP não encontrado!',
							text: 'Porfavor, verifique o CEP digitado.'
						});

                        $('.address').css('display', 'block');
                        $("#uf").focus();
                    }
                });
            } else {
                limpa_formulário_cep();
                Swal.fire({
                    icon: 'error',
                    title: 'CEP invalido!',
                    text: 'Formato de CEP inválido.'
                });
                $('.address').css('display', 'block');
                $("#uf").focus();
            }
        } else {
            limpa_formulário_cep();
            $('.address').css('display', 'block');
            $("#uf").focus();
        }
    });

    // Login
    $('form#login').off('submit').on('submit', function (e) {
        e.preventDefault();
        $('.btnLogin').prop('disabled', true).css('opacity', '0.7').html('Acessando...');

        let cpfField = this.cpf;
        let passwordField = this.password;
        let rememberMeField = this['remember-me'];

        if (rememberMeField && rememberMeField.checked) {
            localStorage.setItem("storedCpf", cpfField.value);
            localStorage.setItem("storedPassword", passwordField.value);
        } else {
            localStorage.removeItem("storedCpf");
            localStorage.removeItem("storedPassword");
        }

        $('.step-1').removeClass('error success');

        var var_form_data = $(this).serialize();

        $.post(
            "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-login.php",
            var_form_data,
            function (retorno) {
            // retorno é 0,1,2 ou 3 (string)
            if (retorno == 1) {
                $('.step-1').addClass('success');
                $(".step-1 p.message").text("Autenticado com sucesso!").show();
                window.location.href = '/ofertas/';
                return;
            }

            if (retorno == 2) {
                // draft com email: perguntar se quer reativar
                $('.step-1').addClass('error');
                $(".step-1 p.message").hide();

                Swal.fire({
                icon: 'warning',
                title: 'Cadastro desativado',
                text: 'Seu cadastro está desativado. Deseja reativá-lo? Enviaremos um código para o seu e-mail.',
                showCancelButton: true,
                confirmButtonText: 'Sim, enviar código',
                cancelButtonText: 'Cancelar'
                }).then(result => {
                if (!result.isConfirmed) {
                    $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
                    return;
                }

                // Envia código
                $.post(
                    "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-reactivate-send-code.php",
                    {
                    cpf: $('form#login input[name=cpf]').val(),
                    password: $('form#login input[name=password]').val()
                    },
                    function (res) {
                    if (!res || !res.success) {
                        Swal.fire({
                        icon: 'error',
                        title: 'Não foi possível enviar o código',
                        text: res && res.message ? res.message : 'Tente novamente ou contate o supermercado.'
                        });
                        $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
                        return;
                    }

                    // Pergunta o código
                    Swal.fire({
                        icon: 'info',
                        title: 'Verifique seu e-mail, cheque o spam caso não encontre',
                        html: 'Enviamos um código para: <b>' + (res.email_masked || '') + '</b><br>Digite o código abaixo:',
                        input: 'text',
                        inputAttributes: { maxlength: 6, autocapitalize: 'off', autocorrect: 'off' },
                        showCancelButton: true,
                        confirmButtonText: 'Confirmar',
                        cancelButtonText: 'Cancelar',
                        preConfirm: (value) => {
                        if (!value) {
                            Swal.showValidationMessage('Informe o código recebido por e-mail.');
                        }
                        return value;
                        }
                    }).then(resultCode => {
                        if (!resultCode.isConfirmed) {
                        $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
                        return;
                        }

                        const code = $.trim(resultCode.value);

                        $.post(
                        "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-reactivate-verify.php",
                        {
                            cpf: $('form#login input[name=cpf]').val(),
                            password: $('form#login input[name=password]').val(),
                            code: code
                        },
                        function (verify) {
                            if (verify && verify.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Cadastro reativado!',
                                text: verify.message || 'Você será redirecionado.'
                            }).then(() => {
                                window.location.href = '/ofertas/';
                            });
                            } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Código inválido',
                                text: (verify && verify.message) ? verify.message : 'Não foi possível reativar. Tente novamente.'
                            });
                            $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
                            }
                        },
                        'json'
                        );
                    });
                    },
                    'json'
                );
                });

                return;
            }

            if (retorno == 3) {
                // draft sem e-mail
                $('.step-1').addClass('error');
                $(".step-1 p.message")
                .text('Não foi possível reativar a conta por falta de e-mail cadastrado. Contate o supermercado.')
                .show();
                $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
                return;
            }

            // retorno 0 ou qualquer outro → login inválido
            $('.step-1').addClass('error');
            $(".step-1 p.message").text("Dados incorretos, favor verificar.").show();
            $('.btnLogin').html('Acessar').css('opacity', '1').prop('disabled', false);
            }
        );
    });

    // Recuperação de senha
    $('form#forgot-password').off('submit').on('submit', function (e) {
      e.preventDefault();
  
      let formData = $(this).serialize();
      let $btn = $('.step-3 .btnDefault');
      $('.step-3').removeClass('error success');
      $('#auth').removeClass('login');
  
      $.post("/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-change-password.php", formData, function (retorno) {
        retorno = JSON.parse(retorno);
  
        if (retorno.success) {
          $('.step-3').addClass('success');
          $(".step-3 p.message").text(retorno.message).show();
  
          codigoVerificacao = retorno.codigo_verificacao;
          expiracaoCodigo = Math.floor(Date.now() / 1000) + (15 * 60);
          sessionStorage.setItem("cpf", retorno.cpf);
  
          setTimeout(() => {
            codigoVerificacao = null;
            expiracaoCodigo = null;
            Swal.fire({
                icon: 'error',
                title: 'Código de verificação expirou!',
                text: 'Solicite um novo.'
            });
          }, 10 * 60 * 1000);
  
          changeStep(4);
  
        } else {
          $('.step-3').addClass('error');
          $(".step-3 p.message").text(retorno.message).show();
        }
  
        $btn.prop('disabled', false).text('Enviar');
      });
    });
  
    // Verificação do código
    $('#verify-code').off('click').on('click', function () {
        let codigoDigitado = $('#verification-code').val();

        $.post("/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-verify-code.php", {
            codigo: codigoDigitado
        }, function (resposta) {
            if (resposta.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Código verificado com sucesso!',
                    text: 'Sua senha foi trocada com sucesso.'
                });
                changeStep(5);
            } else {
                Swal.fire({
                    icon: 'error',
                    title: resposta.message,
                    text: 'Tente novamente.'
                });
            }
        });
    });

    // Redefinir senha
    $('#reset-password').off('click').on('click', function () {
      let novaSenha = $('#new-password').val();
      let confirmarSenha = $('#confirm-password').val();
      let cpf = sessionStorage.getItem("cpf");
  
      if (novaSenha !== confirmarSenha) {
        Swal.fire({
            icon: 'error',
            title: 'Senhas não conferem!',
            text: 'Tenha certeza que são as mesmas senhas.'
        });
        return;
      }
  
      $.post("/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-update-password.php", {
        senha: novaSenha,
        cpf: cpf
      }, function (retorno) {
        retorno = JSON.parse(retorno);
        if (retorno.success) {
            Swal.fire({
                icon: 'success',
                title: 'Perfil atualizado!',
                text: "Senha atualizada com sucesso!",
                timer: 2000,
                showConfirmButton: false
            });
          codigoVerificacao = null;
          changeStep(1);
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Erro ao atualizar senha',
                text: 'Houve um erro ao atualizar a senha. Por favor, tente novamente.'
            });
        }
      });
    });
    
    // FUNÇÃO PARA LEMBRAR ACESSO
    var cpfField = document.querySelector("form#login input[name='cpf']");
    var passwordField = document.querySelector("form#login input[name='password']");
    var rememberMeField = document.querySelector("form#login input[name='remember-me']");

    // Recuperar os valores armazenados no local storage
    let storedCpf = null, storedPassword = null;
    try {
        storedCpf = localStorage.getItem("storedCpf");
        storedPassword = localStorage.getItem("storedPassword");
    } catch {}

    if (storedCpf && cpfField) {
        cpfField.value = storedCpf;
        if (rememberMeField) rememberMeField.checked = true;
    }
    if (storedPassword && passwordField) {
        passwordField.value = storedPassword;
    }

    // REALIZA O CADASTRO DO USUÁRIO
    $(document).off('submit', '#cadastro').on('submit', '#cadastro', function (e) {
        e.preventDefault();

        // Seleciona os campos de endereço
        const camposEndereco = [
            document.querySelector('input[name=estado]'),
            document.querySelector('input[name=cidade]'),
            document.querySelector('input[name=bairro]'),
            document.querySelector('input[name=rua]')
        ];

        let enderecoInvalido = false;


        if(!register_simpliefied){   
            // Verifica se algum campo de endereço está vazio
            camposEndereco.forEach(function (campo) {
                if (campo && campo.value.trim() === '') {
                    enderecoInvalido = true;
                }
            });

            // Se algum campo estiver vazio, exibe as divs .address e impede o envio
            if (enderecoInvalido) {
                document.querySelectorAll('.address').forEach(function (div) {
                    div.style.display = 'block';
                });
                $("#uf").focus();
                $('.step-2').addClass('error');
                $(".step-2 p.message")
                    .text('Por favor, preencha todos os campos de endereço antes de continuar.')
                    .show();
                return;
            }
        }


        // Caso todos os campos de endereço estejam preenchidos, prossegue com a validação ou envio
        var inputCPF             = document.querySelector('form#cadastro input[name=cpf]');
        var inputEmail           = document.querySelector('form#cadastro input[name=email]');
        var inputSenha           = document.querySelector('form#cadastro input[name=password]');
        var inputConfirmarSenha  = document.querySelector('form#cadastro input[name=confirmar-password]');

        // Validação do CPF
        var cpf = inputCPF.value;
        if (!validateCPF(cpf)) {
            $('.step-2').addClass('error');
            $(".step-2 p.message")
                .text('CPF inválido. Por favor, digite um CPF válido.')
                .show();
            return;
        }

        // Validação da senha
        var senha          = inputSenha.value;
        var confirmarSenha = inputConfirmarSenha.value;
        if (senha !== confirmarSenha) {
            $('.step-2').addClass('error');
            $(".step-2 p.message")
                .text('As senhas não conferem. Por favor, digite a mesma senha nos dois campos.')
                .show();
            return;
        }

        // Feedback de carregamento
        $('.load')
            .prop('disabled', true)
            .css('opacity', '0.7')
            .html('Cadastrando...');

        // Envia os dados via AJAX
        var formData = new FormData(this);

        $.ajax({
            type: 'POST',
            url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-register.php",
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json', // 🔑 jQuery já entrega como objeto
            success: function (response) {
                // Se vier erro
                if (response && response.error) {
                    $('.step-2').addClass('error');

                    const msg = (response.error || '').toString();

                    // CPF em draft com opção de reativar
                    if (response.reactivate) {

                        $(".step-2 p.message").text(msg).show();

                        $('.load')
                            .html('Cadastrar')
                            .css('opacity', '1')
                            .prop('disabled', false);

                        Swal.fire({
                            icon: 'info',
                            title: 'Reativar cadastro?',
                            html:
                                `<p>${msg}</p>` +
                                (response.email_masked
                                    ? `<p>Código enviado para: <b>${response.email_masked}</b></p>`
                                    : ''),
                            input: 'text',
                            inputLabel: 'Digite o código recebido',
                            inputPlaceholder: 'Código de 6 dígitos',
                            showCancelButton: true,
                            confirmButtonText: 'Confirmar',
                            cancelButtonText: 'Cancelar',
                            preConfirm: (code) => {
                                code = (code || '').trim();
                                if (!code) {
                                    Swal.showValidationMessage('Informe o código de verificação.');
                                    return false;
                                }

                                // Valida código de reativação
                                return $.ajax({
                                    url: "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-reactivate-verify.php",
                                    type: "POST",
                                    dataType: "json",
                                    data: {
                                        cpf: $('form#cadastro input[name=cpf]').val(),
                                        password: $('form#cadastro input[name=password]').val(),
                                        code: code
                                    }
                                }).then(function (res) {
                                    if (!res || !res.success) {
                                        Swal.showValidationMessage(res && res.message
                                            ? res.message
                                            : 'Código inválido ou expirado.');
                                        return false;
                                    }
                                    return res;
                                }).catch(function () {
                                    Swal.showValidationMessage('Erro ao validar código. Tente novamente.');
                                    return false;
                                });
                            }
                        }).then(function (result) {
                            if (!result.isConfirmed || !result.value) return;

                            const res = result.value;
                            if (res.success) {
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Cadastro reativado!',
                                    text: res.message || 'Sua conta foi reativada com sucesso.',
                                    timer: 2000,
                                    showConfirmButton: false
                                }).then(function () {
                                    window.location.href = '/ofertas/';
                                });
                            }
                        });

                    }
                    // Caso sem e-mail cadastrado para reativar
                    else if (response.code === 'no_email') {

                        $(".step-2 p.message").text(msg).show();

                        Swal.fire({
                            icon: 'error',
                            title: 'Não foi possível reativar',
                            text: msg
                        });

                        $('.load')
                            .html('Cadastrar')
                            .css('opacity', '1')
                            .prop('disabled', false);

                    }

                    // CPF já cadastrado (status publish)
                    else if (response.code === 'cpf_exists') {

                        $(".step-2 p.message").text(msg).show();

                        // foca no campo CPF
                        $('form#cadastro input[name=cpf]').focus();

                        Swal.fire({
                            icon: 'error',
                            title: 'CPF já cadastrado',
                            text: msg
                        });

                        $('.load')
                            .html('Cadastrar')
                            .css('opacity', '1')
                            .prop('disabled', false);
                    }


                    // Erro "normal"
                    else {
                        $(".step-2 p.message").text(msg).show();

                        $('.load')
                            .html('Cadastrar')
                            .css('opacity', '1')
                            .prop('disabled', false);
                    }

                    return;
                }

                // Sucesso (cadastro novo)
                if (response && response.success) {
                    $('.step-2')
                        .removeClass('error')
                        .addClass('success');

                    $(".step-2 p.message")
                        .text(response.success.toString())
                        .show();

                    setTimeout(function () {
                        window.location.href = '/ofertas/';
                    }, 1000);

                    return;
                }

                // Fallback se vier algo inesperado
                $('.step-2').addClass('error');
                $(".step-2 p.message")
                    .text('Erro inesperado ao cadastrar. Tente novamente.')
                    .show();

                $('.load')
                    .html('Cadastrar')
                    .css('opacity', '1')
                    .prop('disabled', false);
            },
            error: function () {
                Swal.fire({
                    icon: 'error',
                    title: response.error || 'Erro ao cadastrar',
                    text: 'Por favor, tente novamente.'
                });

                $('.load')
                    .html('Cadastrar')
                    .css('opacity', '1')
                    .prop('disabled', false);
            }
        });
    });

}

let cpfBloqueado = false;

// $(document).on('blur', '#cadastro input[name=cpf]', function () {
//     const $cpfInput = $(this);
//     let cpf = $cpfInput.val().trim();

//     // Se o campo estiver vazio, só limpa estado
//     if (cpf === '') {
//         cpfBloqueado = false;
//         $cpfInput.removeClass('is-invalid is-valid');
//         return;
//     }

//     // Validação básica no front
//     if (!validateCPF(cpf)) {
//         cpfBloqueado = true;
//         $cpfInput.addClass('is-invalid').removeClass('is-valid');

//         $('.step-2').addClass('error');
//         $(".step-2 p.message")
//             .text('CPF inválido. Por favor, digite um CPF válido.')
//             .show();

//         return;
//     }

//     // Chama o endpoint de verificação
//     $.ajax({
//         type: 'POST',
//         url: window.location.origin + "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-check-cpf.php",
//         data: { cpf: cpf },
//         dataType: 'json',
//         success: function (resp) {
//             // Erro de validação no backend
//             if (resp.error) {
//                 cpfBloqueado = true;
//                 $cpfInput.addClass('is-invalid').removeClass('is-valid');

//                 $('.step-2').addClass('error');
//                 $(".step-2 p.message").text(resp.error).show();
//                 return;
//             }

//             // CPF já cadastrado (publish)
//             if (resp.status === 'publish') {
//                 cpfBloqueado = true;
//                 $cpfInput.addClass('is-invalid').removeClass('is-valid');

//                 $('.step-2').addClass('error');
//                 $(".step-2 p.message")
//                     .text(resp.message || 'CPF já cadastrado.')
//                     .show();

//                 Swal.fire({
//                     icon: 'error',
//                     title: 'CPF já cadastrado',
//                     text: resp.message || 'Este CPF já está cadastrado no sistema.'
//                 });

//                 return;
//             }

//             // CPF em draft (cadastrado mas desativado) – aqui você pode até
//             // já preparar o fluxo de reativação se quiser
//             if (resp.status === 'draft') {
//                 cpfBloqueado = true;
//                 $cpfInput.addClass('is-invalid').removeClass('is-valid');

//                 $('.step-2').addClass('error');
//                 $(".step-2 p.message")
//                     .text(resp.message || 'CPF cadastrado, porém desativado.')
//                     .show();

//                 Swal.fire({
//                     icon: 'info',
//                     title: 'Cadastro desativado',
//                     text: resp.message || 'Este CPF já possui um cadastro desativado.'
//                 });

//                 return;
//             }

//             // CPF liberado
//             cpfBloqueado = false;
//             $cpfInput.addClass('is-valid').removeClass('is-invalid');

//             $('.step-2').removeClass('error');
//             $(".step-2 p.message").hide();
//         },

//         error: function () {
//             Swal.fire({
//                 icon: 'warning',
//                 title: 'Não foi possível verificar o CPF',
//                 text: 'Tente novamente ou conclua o cadastro normalmente.'
//             });
//         }
//     });
// });

function validateCPF(cpf) {
    // implementação da validação do CPF
    cpf = cpf.replace(/[^\d]+/g,'');
    if(cpf == '') return false;
    // Elimina CPFs invalidos conhecidos
    if (cpf.length != 11 ||
        cpf == "00000000000" ||
        cpf == "11111111111" ||
        cpf == "22222222222" ||
        cpf == "33333333333" ||
        cpf == "44444444444" ||
        cpf == "55555555555" ||
        cpf == "66666666666" ||
        cpf == "77777777777" ||
        cpf == "88888888888" ||
        cpf == "99999999999")
        return false;
    // Valida 1o digito
    add = 0;
    for (i=0; i < 9; i ++)
        add += parseInt(cpf.charAt(i)) * (10 - i);
        rev = 11 - (add % 11);
        if (rev == 10 || rev == 11)
        rev = 0;
        if (rev != parseInt(cpf.charAt(9)))
        return false;
    // Valida 2o digito
    add = 0;
    for (i = 0; i < 10; i ++)
        add += parseInt(cpf.charAt(i)) * (11 - i);
    rev = 11 - (add % 11);
    if (rev == 10 || rev == 11)
        rev = 0;
    if (rev != parseInt(cpf.charAt(10)))
        return false;
    return true;
}

function validateEmail(email) {
    // implementação da validação do e-mail
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
}

window.validateBirthdate = function () {
    var birthdate = $(".birthdate").val();
    var today = new Date();
    var birthdateArray = birthdate.split("/");
    var birthdateDate = new Date(birthdateArray[2], birthdateArray[1] - 1, birthdateArray[0]);

    if (isNaN(birthdateDate.getTime())) {
        Swal.fire({
            icon: 'error',
            title: 'Data inválida!',
            text: 'A data de nascimento informada é inválida.'
        });
        $('.birthdate').val('');
        $('.birthdate').focus();
        return false;
    }

    if (today.getFullYear() - birthdateDate.getFullYear() < 12) {
        Swal.fire({
            icon: 'error',
            title: 'Idade inválida!',
            text: 'Você deve ter pelo menos 12 anos para cadastro.'
        });
        $('.birthdate').val('');
        $('.birthdate').focus();
        return false;
    }
}
$(document).on('change', '.birthdate', validateBirthdate);

function initCidadesSelect() {

    fetch(window.location.origin + "/wp-content/themes/app/mobile-view/dist/json/cidades.json")
    .then(response => response.json())
    .then(data => {
        let selectCidade = document.getElementById("cidade");
        if (!selectCidade) return;

        data.forEach(cidade => {
            let option = document.createElement("option");
            option.value = cidade.descricao;
            option.textContent = cidade.descricao;
            selectCidade.appendChild(option);
        });

        // Inicializa o Select2
        $('#cidade').select2({
            placeholder: "Selecione sua cidade",
            allowClear: true,
            width: '100%'
        });
    })
    .catch(error => console.error("Erro ao carregar cidades:", error));
}
  
function initForgotPasswordTabs() {
    const tabs = document.querySelectorAll(".tab");
    const emailContainer = document.getElementById("email-container");
    const whatsappContainer = document.getElementById("whatsapp-container");

    if (tabs.length === 0 || !emailContainer || !whatsappContainer) {
        // console.log('saindo da função');
        return;
    }

    function showTab(tabId) {
        // console.log('tabId', tabId);
        emailContainer.classList.add("hidden");
        whatsappContainer.classList.add("hidden");

        if (tabId === "tab-email") {
            emailContainer.classList.remove("hidden");
        } else if (tabId === "tab-whatsapp") {
            whatsappContainer.classList.remove("hidden");
        }
    }

    tabs.forEach(tab => {
        tab.addEventListener("click", function () {
            tabs.forEach(t => t.classList.remove("active"));
            this.classList.add("active");
            showTab(this.id);
        });
    });

    showTab("tab-email");
}


initAuthEvents();