<article class="modal" id="notificacao">
	
	<div class="container-fluid">
		
		<div class="box">
			<div class="headModal">
				<h3>Notificação</h3>
				<span id="closeModal">
					<i class="fa-solid fa-arrow-left" onclick="$('#notificacao').removeClass('open');"></i>
				</span>
			</div>
				<div class="contentModal">
					<?php 

					$sql = "SELECT * FROM wpp_sender 
					WHERE data_agendamento BETWEEN DATE_SUB(NOW(), INTERVAL 3 DAY) AND NOW() 
					AND status = 2 AND channel = 'push'
					AND (id_segmentation IN ('" . implode("','", $user_tags) . "') OR id_segmentation = '$user_loja' OR id_segmentation IS NULL) ORDER BY id ASC";
					$result = mysqli_query($database_connection, $sql);
					$countTabloide = mysqli_num_rows($result);
					
					while ($row = mysqli_fetch_assoc($result)) { 
						$dataAgendamento = date('Y-m-d H:i:s', strtotime($row['data_agendamento'])); 
						?>
						<div style="margin-bottom: 15px; padding: 10px; border-bottom: 1px solid #ddd;">
							<?php if (!empty($row['title'])) { ?>
								<p style="margin: 0; font-weight: bold; font-size: 18px;"><?php echo htmlspecialchars($row['title']); ?></p>
							<?php } ?>

							<?php if (!empty($row['text'])) { ?>
								<strong><?php echo htmlspecialchars($row['text']); ?></strong><br>
							<?php } ?>

							<small><?php echo date('d/m/Y H:i', strtotime($row['data_agendamento'])); ?></small>

							<!-- Exibir imagem apenas se houver no campo 'file' -->
							<?php if (!empty($row['file'])) { ?>
								<div style="margin-top: 10px;">
									<a href="<?php echo htmlspecialchars($row['file']); ?>" data-fancybox="notificacao"><img src="<?php echo htmlspecialchars($row['file']); ?>" alt="Imagem da notificação" style="max-width: 100%; height: auto; border-radius: 5px;"></a>
								</div>
							<?php } ?>
						</div>
					<?php } ?>
					<span id="ultimaNotificacao"
						data-horario="<?php echo date('c', strtotime($dataAgendamento)); ?>">
					</span>
					<?php if($countTabloide == 0){ ?>
						<div class="no-results">
							<p>Nenhuma notificação disponível nos últimos 2 dias.</p>
						</div>
					<?php } ?>

					<script> const countTabloide = <?= $countTabloide ?>; </script>

				</div>
			</div>
		</div>	
	</div>

</article>

<article class="modal" id="jornais">
	
	<div class="container-fluid">
		
		<div class="box">
			<div class="headModal">
				<h3>Folhetos</h3>
				<span id="closeModal">
					<i class="fa-solid fa-arrow-left" onclick="$('#jornais').removeClass('open');"></i>
				</span>
			</div>
			<div class="contentModal" id="listaJornais">

			</div>
		</div>
		
	</div>

</article>

<article class="modal" id="minha-conta">
	
	<div class="container-fluid">
		
		<div class="box">

			<div class="headModal">
				<h3>Menu</h3>
				<span id="closeModal">
					<i class="fa-solid fa-arrow-left" onclick="$('#minha-conta').removeClass('open');"></i>
				</span>
			</div>

			<div class="contentModal">
				<div class="menu__account row">
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="$('#compras').addClass('open');"><i class="fa-solid fa-cart-shopping"></i> Histórico de compras</a>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="$('#extratos').addClass('open');"><i class="fa-solid fa-money-bill-transfer"></i> Histórico de créditos</a>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="$('#indicados').addClass('open');"><i class="fa-solid fa-user-plus"></i> Minhas indicações</a>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="$('#change-password').addClass('open');"><i class="fa-solid fa-user-pen"></i> Alterar meu perfíl</a>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="$('#sacola').addClass('open');"><i class="fa-solid fa-bag-shopping"></i> Sacola</a>
						</div>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<div class="box__menu__account">
							<a onclick="confirmarSaida();"><i class="fa-solid fa-right-from-bracket"></i> Sair do aplicativo</a>
						</div>
					</div>
				</div>
			</div>
		</div>
		
	</div>

</article>