<?php

    function hexToRGBA($hex, $alpha) {
        $hex = str_replace('#', '', $hex);
        if (strlen($hex) == 3) {
            $r = hexdec(str_repeat($hex[0], 2));
            $g = hexdec(str_repeat($hex[1], 2));
            $b = hexdec(str_repeat($hex[2], 2));
        } else {
            $r = hexdec(substr($hex, 0, 2));
            $g = hexdec(substr($hex, 2, 2));
            $b = hexdec(substr($hex, 4, 2));
        }
        return "rgba($r, $g, $b, $alpha)";
    }

    $colorBase = get_data('app_config', 'color'); // ex: #e8b730
    $colorLight = hexToRGBA($colorBase, 0.3); // cor principal com transparência
    $colorLighter = hexToRGBA($colorBase, 0.15); // ainda mais clara
?>
    
<style>
    :root {
        --main-color: <?= $colorBase ?>;
        --main-color-light: <?= $colorLight ?>;
        --main-color-lighter: <?= $colorLighter ?>;
        --swal2-confirm-button-background-color: <?= $colorBase ?> !important;
    }

    .copyright{
        position: absolute;
        left: 50%;
        bottom: 20px;
        transform: translateX(-50%);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    footer .copyright{
        bottom: 0;
    }

    .copyright svg path {
        fill: var(--main-color);
    }

    .copyright span{
        font-size: 8px;
        color: var(--main-color);
    }

    .copyright svg{
        width: 40px;
        height: 40px;
    }

    #pageLoader {
        position: fixed;
        top: 0; left: 0;
        width: 100vw; height: 100vh;
        background-color: #ffffff;
        display: flex;
        align-items: center;
        justify-content: center;
        flex-direction: column;
        z-index: 9999999999 !important
    }

    .loaderContent {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        transform: translateY(-90px);
        padding: 20px 0 40px 0;
    }

    .loaderContent p{
        margin: 0;
        font-size: 26px;
        line-height: 32px;
        font-weight: 700;
        text-align: center;
        padding: 0 30px;
        background: white;
        z-index: 1;
    }

    .loaderContent span{
        font-size: 42px;
        line-height: 42px;
    }

    .dots::after {
        content: '';
        animation: dots 1.2s infinite steps(3);
    }

    @keyframes dots {
        0% { content: ''; }
        33% { content: '.'; }
        66% { content: '..'; }
        100% { content: '...'; }
    }

    .animated-background {
        background: linear-gradient(to top right, #ffffff, #f8f8f8);
    }

    .shape {
        position: absolute;
        border-radius: 50px;
        filter: blur(8px);
        opacity: 0.4;
        animation: float 10s infinite ease-in-out;
    }

    .shape1 {
        width: 250px; height: 80px;
        background: linear-gradient(45deg, var(--main-color), var(--main-color-light));
        top: 10%; left: -120px;
        animation-delay: 0s;
    }

    .shape2 {
        width: 200px; height: 60px;
        background: linear-gradient(135deg, var(--main-color), var(--main-color-lighter));
        top: 40%; left: -160px;
        animation-delay: 2s;
    }

    .shape3 {
        width: 220px; height: 60px;
        background: linear-gradient(120deg, var(--main-color), var(--main-color-light));
        top: 70%; left: -200px;
        animation-delay: 4s;
    }

    .shape4 {
        width: 150px; height: 50px;
        background: linear-gradient(120deg, var(--main-color), var(--main-color-lighter));
        top: 85%; left: -140px;
        animation-delay: 6s;
    }

    @keyframes float {
        0% {
            transform: translateX(0) rotate(0deg);
            opacity: 0.2;
        }
        50% {
            transform: translateX(120vw) rotate(360deg);
            opacity: 0.4;
        }
        100% {
            transform: translateX(0) rotate(720deg);
            opacity: 0.2;
        }
    }

    .bg-abstract {
        position: fixed;
        top: 0; left: 0;
        width: 100vw; height: 100vh;
        background: #ffffff;
        overflow: hidden;
        z-index: -1;
    }

    /* Bolhas grandes */
    .blob {
        position: absolute;
        border-radius: 50%;
        opacity: 0.2;
        background: var(--main-color-light);
    }

    .blob1 {
        width: 350px;
        height: 350px;
        top: -100px;
        left: -100px;
    }

    .blob2 {
        width: 400px;
        height: 400px;
        bottom: -120px;
        right: -120px;
    }

    /* Círculos sólidos ou vazados */
    .circle {
        position: absolute;
        border-radius: 50%;
        z-index: 1;
    }

    .circle1 {
        width: 100px;
        height: 100px;
        background: var(--main-color);
        top: -48px;
        left: -16px;
    }

    .circle2 {
        width: 40px; height: 40px;
        background: var(--main-color-lighter);
        top: 200px;
        left: 75%;
    }

    .circle3 {
        width: 60px; height: 60px;
        border: 4px solid var(--main-color);
        background: transparent;
        bottom: 80px;
        right: 15%;
    }

    /* Pontos decorativos (grade) */
    .dots {
        position: absolute;
        display: grid;
        grid-template-columns: repeat(3, 6px);
        grid-template-rows: repeat(3, 6px);
        gap: 6px;
    }

    .dots div {
        width: 6px;
        height: 6px;
        background: var(--main-color);
        border-radius: 50%;
    }

    .dots1 {
        top: 35%;
        left: 10%;
    }

    .dots2 {
        bottom: 20%;
        right: 20%;
    }

    .dots1, .dots2 {
        display: grid;
        grid-template-columns: repeat(3, 6px);
        grid-template-rows: repeat(3, 6px);
    }

    .dots1::before, .dots2::before,
    .dots1::after, .dots2::after {
        content: '';
        width: 6px;
        height: 6px;
        background: var(--main-color);
        border-radius: 50%;
    }

    /* Linhas diagonais */
    .line {
        position: absolute;
        width: 60px;
        height: 3px;
        background: var(--main-color);
        opacity: 0.4;
        transform: rotate(45deg);
    }

    .line1 {
        top: 30%;
        left: 30%;
    }

    .line2 {
        bottom: 25%;
        right: 35%;
    }

    .iconAnimation {
        position: relative;
        width: 100px;
        height: 100px;
        margin-bottom: 100px;
        display: flex;
        align-items: flex-end;
        justify-content: center;
        overflow: visible;
        z-index: -1;
    }

    .iconAnimation i {
        font-size: 48px;
        color: var(--main-color);
        opacity: 0;
        animation: floatIcon 3s ease-in-out forwards;
        position: absolute;
        bottom: 0;
    }

    @keyframes floatIcon {
        0% {
            transform: translateY(0) scale(1) rotate(0deg);
            opacity: 0;
        }
        10% {
            opacity: 1;
        }
        40% {
            transform: translateY(-60px) scale(1.1) rotate(30deg);
            opacity: 0.7;
        }
        70% {
            transform: translateY(-10px) scale(1) rotate(360deg);
            opacity: 0.4;
        }
        100% {
            transform: translateY(100px) scale(0.8) rotate(720deg);
            opacity: 0;
        }
    }

</style>

<?php

    // Só mostra o loader na página /ofertas/
    if ( function_exists('is_page') && ! is_page('ofertas') ) {
        return; // sai do arquivo sem imprimir nada
    }
    
?>

<div id="pageLoader" class="animated-background bg-abstract">
    
    <!-- círculos -->
    <div class="circle circle1"></div>
    <div class="circle circle2"></div>
    <div class="circle circle3"></div>

    <!-- bolhas maiores -->
    <div class="blob blob1"></div>
    <div class="blob blob2"></div>

    <!-- bolinhas pequenas -->
    <div class="dot-group dot1"></div>
    <div class="dot-group dot2"></div>

    <!-- linhas -->
    <div class="line line1"></div>
    <div class="line line2"></div>
    
    <div class="loaderContent">

        <!-- Animação dos icones -->
        <div class="iconAnimation">
            <i class="fa-solid fa-drumstick-bite"></i> <!-- Primeira animação inicia com esse -->
        </div>

        <p id="loaderText">Carregando...</p>
    </div>

    <!-- shapes animados -->
    <span class="shape shape1"></span>
    <span class="shape shape2"></span>
    <span class="shape shape3"></span>
    <span class="shape shape4"></span>

    <div class="copyright">
        <span>Desenvolvido por</span>
        <?php include $_SERVER['DOCUMENT_ROOT'] . '/wp-content/themes/app/mobile-view/dist/images/logo-copyright.svg'; ?>
    </div>

</div>

<script>
    // JS
    const frases = [
        'Seja bem-vindo(a)!',
        'Carregando informações...',
        'Buscando ofertas...',
        'Preparando experiência...',
        'Tudo pronto em instantes!'
    ];

    let index = 0;
    const loaderText = document.getElementById('loaderText');

    function digitarFrase(frase, elemento, i = 0) {
        if (i < frase.length) {
            elemento.textContent += frase.charAt(i);
            setTimeout(() => digitarFrase(frase, elemento, i + 1), 50);
        }
    }

    function mostrarFraseDigitando() {
        loaderText.textContent = '';
        digitarFrase(frases[index], loaderText);
        index = (index + 1) % frases.length;
    }

    setInterval(mostrarFraseDigitando, 2000);

    // Exemplo: ao carregar a página
    window.addEventListener('load', () => {
        setTimeout(() => {
            document.getElementById('pageLoader').classList.add('fade-out');
        }, 500); // tempo opcional antes de sumir
    });

    const icones = [
        'fa-drumstick-bite',   // Açougue
        'fa-cart-shopping',       // Padaria
        'fa-carrot',            // Hortifruti
        'fa-cheese',            // Laticínios
        'fa-fish',              // Peixaria
        'fa-egg',               // Ovos
    ];

    let current = 0;
    const iconContainer = document.querySelector('.iconAnimation');

        function mostrarProximoIcone() {
        const icon = document.createElement('i');
        icon.className = `fa-solid ${icones[current]}`;
        iconContainer.innerHTML = ''; // Limpa o anterior
        iconContainer.appendChild(icon);

        current = (current + 1) % icones.length;
    }

    setInterval(mostrarProximoIcone, 3000); // troca a cada 3s
    mostrarProximoIcone(); // primeiro ícone
</script>