<?php  
    session_start();
    require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';
    include(get_template_directory() . '/web-panel/functions/database-connection.php'); 

    if ($_POST['action'] === 'update-ativo') {
        $id = $_SESSION['usuario']['id'];
        $ativo = intval($_POST['ativo']);

        // Corrigido: removido "=" duplicado
        $update_query = "UPDATE customers SET wpp_lgpd = '$ativo' WHERE cliente_uuid = '$id'";

        if (mysqli_query($database_connection, $update_query)) {
            echo json_encode(['success' => 'Cadastro atualizado com sucesso!']);
        } else {
            echo json_encode(['error' => 'Erro ao atualizar: ' . mysqli_error($database_connection)]);
        }

        exit;
    }
    
    elseif ($_POST['action'] === 'jornais') {
        $clienteUuid = $_SESSION['usuario']['id'] ?? null;
        $lojaAtual = $_POST['loja'] ?? '';
        $jornaisPermitidos = [];

        if (!$clienteUuid) {
            echo json_encode([]);
            exit;
        }

        $sql = "SELECT * FROM newspaper ORDER BY pos ASC";
        $result = $database_connection->query($sql);

        while ($jornal = $result->fetch_assoc()) {
            $lojasPermitidas = array_filter(explode(';', $jornal['loja'] ?? ''));
            $publicosPermitidos = array_filter(explode(';', $jornal['publico'] ?? ''));

            $temAcessoPorLoja = $lojaAtual && in_array($lojaAtual, $lojasPermitidas);
            $temAcessoPorTag = false;

            if (!empty($publicosPermitidos)) {
                $placeholders = implode(',', array_fill(0, count($publicosPermitidos), '?'));
                $tipos = str_repeat('i', count($publicosPermitidos)) . 's'; // tags = int, clienteUuid = string
                $params = [...array_map('intval', $publicosPermitidos), $clienteUuid];

                $sqlCheck = "
                    SELECT 1 FROM related_tag
                    WHERE id_tag IN ($placeholders) AND id_customer = ?
                    LIMIT 1
                ";

                $stmt = $database_connection->prepare($sqlCheck);
                $stmt->bind_param($tipos, ...$params);
                $stmt->execute();
                $check = $stmt->get_result();

                if ($check->num_rows > 0) {
                    $temAcessoPorTag = true;
                }
            }

            if ($temAcessoPorLoja || $temAcessoPorTag) {
                $jornal['cliente_tem_acesso_por_tag'] = $temAcessoPorTag;
                $jornaisPermitidos[] = $jornal;
            }
        }

        echo json_encode([
            'jornais' => $jornaisPermitidos
        ]);
        exit;
    }



?>
