<?php
session_start();
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

header('Content-Type: application/json; charset=utf-8');

function json_response($arr, $code = 200) {
    http_response_code($code);
    echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
    exit;
}

$cpf = $_POST['cpf'] ?? '';
$cpf = trim($cpf);

if ($cpf === '') {
    json_response(['error' => 'CPF não informado.'], 400);
}

// Aqui assumo que você já tem $database_connection e a função existCPF($data, $database_connection)
global $database_connection;

$statusExistente = existCPF(['cpf' => $cpf], $database_connection);

if ($statusExistente === 'publish') {
    json_response([
        'status'  => 'publish',
        'message' => 'CPF já cadastrado.'
    ], 200);
} elseif ($statusExistente === 'draft') {
    json_response([
        'status'  => 'draft',
        'message' => 'CPF cadastrado, porém desativado.'
    ], 200);
}

// Livre
json_response([
    'status'  => 'available',
    'message' => 'CPF disponível.'
], 200);

function existCPF($data, $database_connection) {
  $cpf = $data['cpf'] ?? '';

  $query = "SELECT status FROM customers WHERE cpf = ?";
  $stmt = $database_connection->prepare($query);
  if ($stmt) {
    $stmt->bind_param('s', $cpf);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
      $row = $result->fetch_assoc();
      $stmt->close();
      return $row['status']; // 'publish' ou 'draft'
    }
    $stmt->close();
  }

  return false; // não existe
}