<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/wp-load.php';

/* =====================================================
   HELPERS
===================================================== */

function http_get($url, $timeout = 15, $referer = '', $extraHeaders = []) {
    $ch = curl_init($url);

    $headers = array_merge([
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120 Safari/537.36',
        'Accept-Language: pt-BR,pt;q=0.9,en;q=0.8',
        'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
        'Cache-Control: no-cache',
        'Pragma: no-cache',
    ], $extraHeaders);

    if ($referer) $headers[] = 'Referer: '.$referer;

    // cookies pra reduzir pagina "consent"/bloqueio
    $cookieFile = sys_get_temp_dir() . '/imgsearch_cookie.txt';

    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_TIMEOUT => $timeout,
        CURLOPT_CONNECTTIMEOUT => 6,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_ENCODING => '',

        CURLOPT_COOKIEJAR => $cookieFile,
        CURLOPT_COOKIEFILE => $cookieFile,
    ]);

    $body = curl_exec($ch);
    curl_close($ch);

    return $body ?: '';
}

function ean_is_real($ean) {
    $ean = preg_replace('/\D/', '', (string)$ean);
    if (!preg_match('/^\d{8,14}$/', $ean)) return false;
    if (preg_match('/^0{4,}/', $ean)) return false; // pesáveis
    if ((int)trim($ean, '0') === 0) return false;
    return true;
}

function normalize_url($u) {
    $u = html_entity_decode($u, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    $u = str_replace(['\\u002F','\\/'], '/', $u);
    $u = str_replace('\\', '', $u);
    return trim($u);
}

function render_section_title($label, $count, $url, $query) {
    return '
        <div class="col-12" style="margin:12px 0 6px 0;font-weight:700;">
            '.esc_html($label).' ('.intval($count).')
            <div style="font-weight:400;font-size:12px;word-break:break-all;opacity:.75;margin-top:4px;">
                <div><b>Query:</b> '.esc_html($query).'</div>
                <div><b>URL:</b> '.esc_html($url).'</div>
            </div>
        </div>
    ';
}

function render_debug_box($lines) {
    $html = '<div class="col-12" style="margin:10px 0 12px 0;padding:10px;border:1px dashed #ddd;border-radius:10px;background:#fff;">';
    $html .= '<div style="font-weight:700;margin-bottom:6px;">DEBUG BUSCA</div>';
    foreach ($lines as $k => $v) {
        $html .= '<div style="font-size:12px;line-height:1.35;"><b>'.esc_html($k).':</b> '.esc_html($v).'</div>';
    }
    $html .= '</div>';
    return $html;
}

function render_img_col($src) {
    $onError = "this.closest('.col-4').style.display='none';";
    return '
        <div class="col-4 col-sm-4 col-md-4 col-lg-4" style="padding:0 5px;margin-bottom:10px;">
            <div class="resultadoImagem" style="width:100%;height:110px;border-radius:10px;overflow:hidden;background:#fff;border:1px solid #eee;display:flex;align-items:center;justify-content:center;">
                <img src="'. esc_url($src) .'"
                     style="width:100%;height:100%;object-fit:contain;"
                     onerror="'. esc_attr($onError) .'">
            </div>
        </div>
    ';
}

function unique_limit($arr, $limit = 12) {
    $arr = array_values(array_unique(array_filter($arr)));
    return array_slice($arr, 0, $limit);
}

/* =====================================================
   ENGINES
===================================================== */

/**
 * BING
 * - tenta 1) padrão iusc m="json"
 * - fallback 2) "murl":"https://..."
 */
function bing_images($query, $limit = 12, $exact = false) {
    $query = trim((string)$query);
    $q = $exact ? '"'.$query.'"' : $query;
    $qEnc = urlencode($q);

    $url = "https://www.bing.com/images/search?q={$qEnc}&form=QBIR&first=0";
    $html = http_get($url, 15, 'https://www.bing.com/');

    $imgs = [];

    // 1) clássico iusc m="..."
    if ($html) {
        preg_match_all('/<a[^>]*class="iusc"[^>]*m="([^"]+)"/', $html, $m);
        foreach (($m[1] ?? []) as $raw) {
            $data = json_decode(htmlspecialchars_decode($raw), true);
            if (!empty($data['murl'])) {
                $imgs[] = normalize_url($data['murl']);
            }
            if (count($imgs) >= $limit) break;
        }
    }

    // 2) fallback direto "murl":"..."
    if (count($imgs) < $limit && $html) {
        preg_match_all('/"murl"\s*:\s*"([^"]+)"/i', $html, $m2);
        foreach (($m2[1] ?? []) as $u) {
            $imgs[] = normalize_url($u);
            if (count($imgs) >= $limit) break;
        }
    }

    return [unique_limit($imgs, $limit), $url, $q];
}

/**
 * BRAVE
 * - tenta imageUrl
 * - fallback thumbnail
 */
function brave_images($query, $limit = 12) {
    $query = trim((string)$query);
    $qEnc = urlencode($query);

    $url = "https://search.brave.com/images?q={$qEnc}";
    $html = http_get($url, 15, 'https://search.brave.com/');

    $imgs = [];

    preg_match_all('/"imageUrl":"(https:[^"]+)"/', $html, $m1);
    foreach (($m1[1] ?? []) as $u) {
        $imgs[] = normalize_url($u);
        if (count($imgs) >= $limit) break;
    }

    if (count($imgs) < $limit) {
        preg_match_all('/"thumbnail":"(https:[^"]+)"/', $html, $m2);
        foreach (($m2[1] ?? []) as $u) {
            $imgs[] = normalize_url($u);
            if (count($imgs) >= $limit) break;
        }
    }

    return [unique_limit($imgs, $limit), $url, $query];
}

/**
 * GOOGLE (fallback)
 * OBS: muitas vezes bloqueia no server (consent/captcha) => pode vir 0
 */
function google_images($query, $limit = 12) {
    $query = trim((string)$query);
    $qEnc = urlencode($query);

    $url = "https://www.google.com/search?tbm=isch&q={$qEnc}";
    $html = http_get($url, 15, 'https://www.google.com/');

    $imgs = [];

    preg_match_all('/"ou":"(https?:\/\/[^"]+)"/', $html, $m);
    foreach (($m[1] ?? []) as $u) {
        $imgs[] = normalize_url($u);
        if (count($imgs) >= $limit) break;
    }

    return [unique_limit($imgs, $limit), $url, $query];
}

/**
 * YAHOO BR (como você pediu)
 * - usa br.images.search.yahoo.com + imgty=transparent
 * - pega primeiro data-src / src (resultados)
 * - depois tenta noscript
 */
function yahoo_br_images($query, $limit = 12) {
    $query = trim((string)$query);
    $qEnc = urlencode($query);

    $url = "https://br.images.search.yahoo.com/search/images?p={$qEnc}&imgty=transparent&ei=UTF-8&fr=all&first=0";
    $html = http_get($url, 15, 'https://br.images.search.yahoo.com/');

    $imgs = [];

    if (!$html) {
        return [[], $url, $query];
    }

    // 1) data-src="https://...."
    preg_match_all('/data-src="(https?:\/\/[^"]+)"/i', $html, $m1);
    foreach (($m1[1] ?? []) as $u) {
        $imgs[] = normalize_url($u);
        if (count($imgs) >= $limit) break;
    }

    // 2) src="https://...." (sem pegar svg/ico/data)
    if (count($imgs) < $limit) {
        preg_match_all('/<img[^>]+src="(https?:\/\/[^"]+)"/i', $html, $m2);
        foreach (($m2[1] ?? []) as $u) {
            $u = normalize_url($u);
            if (stripos($u, 'data:') === 0) continue;
            if (preg_match('/\.(svg|ico)(\?|$)/i', $u)) continue;
            $imgs[] = $u;
            if (count($imgs) >= $limit) break;
        }
    }

    // 3) noscript <img src='...'>
    if (count($imgs) < $limit) {
        preg_match_all("/<noscript>\s*<img[^>]+src='([^']+)'/i", $html, $m3);
        foreach (($m3[1] ?? []) as $u) {
            $u = normalize_url($u);
            if (stripos($u, 'data:') === 0) continue;
            if (preg_match('/\.(svg|ico)(\?|$)/i', $u)) continue;
            $imgs[] = $u;
            if (count($imgs) >= $limit) break;
        }
    }

    return [unique_limit($imgs, $limit), $url, $query];
}

/* =====================================================
   ACTIONS
===================================================== */

if (($_POST['action'] ?? '') === 'update') {
    $produto_id  = intval($_POST['productId']);
    $nova_imagem = esc_url_raw($_POST['imagem']);
    update_field('imagem_externa', $nova_imagem, $produto_id);
    echo json_encode(['success' => true, 'mensagem' => 'Imagem atualizada com sucesso.']);
    exit;
}

if (($_POST['action'] ?? '') === 'upload_thumbnail') {
    $productId    = intval($_POST['productId']);
    $attachmentId = intval($_POST['attachmentId']);

    if ($productId > 0 && $attachmentId > 0) {
        set_post_thumbnail($productId, $attachmentId);
        $imageUrl = wp_get_attachment_url($attachmentId);
        update_post_meta($productId, 'imagem_externa', $imageUrl);
        echo 200;
    } else {
        echo 500;
    }
    exit;
}

if (($_POST['action'] ?? '') === 'search') {

    $produto = trim((string)($_POST['produto'] ?? ''));
    $ean     = trim((string)($_POST['ean'] ?? ''));

    $retorno = '<div class="resultados"><div class="row">';

    // Placeholder sempre primeiro
    $placeholder = get_template_directory_uri() . '/web-panel/dist/images/search-images/placeholder.jpg';
    $retorno .= render_img_col($placeholder);

    $eanReal = ean_is_real($ean);

    $debug = [
        'Produto' => $produto,
        'EAN recebido' => ($ean !== '' ? $ean : '(vazio)'),
        'EAN real?' => ($eanReal ? 'SIM (roda EAN + termo)' : 'NÃO (roda só termo)'),
    ];
    #$retorno .= render_debug_box($debug);

    $sections = [];

    // EAN primeiro (se real)
    if ($eanReal) {
        [$imgs, $url, $q] = yahoo_br_images($ean, 1);
        $sections[] = ['label' => 'Yahoo BR (por EAN)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

        [$imgs, $url, $q] = bing_images($ean, 1, false);
        $sections[] = ['label' => 'Bing (por EAN)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

        // [$imgs, $url, $q] = brave_images($ean, 1);
        // $sections[] = ['label' => 'Brave (por EAN)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];
    }

    // Termo sempre
    [$imgs, $url, $q] = yahoo_br_images($produto, 12);
    $sections[] = ['label' => 'Yahoo BR (termo)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

    [$imgs, $url, $q] = bing_images($produto, 12, true);
    $sections[] = ['label' => 'Bing (termo exato)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

    [$imgs, $url, $q] = bing_images($produto, 12, false);
    $sections[] = ['label' => 'Bing (termo)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

    // [$imgs, $url, $q] = brave_images($produto, 12);
    // $sections[] = ['label' => 'Brave (termo)', 'imgs' => $imgs, 'url' => $url, 'q' => $q];

    // Render
    $totalFound = 0;
    foreach ($sections as $sec) {
        $imgs = unique_limit($sec['imgs'], 12);
        $count = count($imgs);
        $totalFound += $count;

        $retorno .= render_section_title($sec['label'], $count, $sec['url'], $sec['q']);
        
        if(count($imgs) > 0){
            foreach ($imgs as $img) {
                $retorno .= render_img_col($img);
            }
        }else{
            $retorno .= '<p style="font-weight:400;font-size:12px;word-break:break-all;opacity:.75;margin-top:4px;">Nenhum resultado encontrado.</p>';
        }

        
    }

    // Google só se ainda estiver muito baixo
    if ($totalFound < 8) {
        if ($eanReal) {
            [$gEan, $gUrlEan, $gQEan] = google_images($ean, 12);
            $retorno .= render_section_title('Google (fallback por EAN)', count($gEan), $gUrlEan, $gQEan);
            foreach ($gEan as $img) $retorno .= render_img_col($img);
        }

        [$gTermo, $gUrlTermo, $gQTermo] = google_images($produto, 12);
        $retorno .= render_section_title('Google (fallback por termo)', count($gTermo), $gUrlTermo, $gQTermo);
        foreach ($gTermo as $img) $retorno .= render_img_col($img);
    }

    $retorno .= '</div></div>';
    echo $retorno;
    exit;
}
