<section class="step-2">

    <form method="POST" id="cadastro" class="row mx-0">
        <?php if (isset($_GET['indicacao'])): ?>
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <label>Indicado por:</label>
                <input class="form-control mb-3" type="text" name="nomeIndicador" value="<?php echo htmlspecialchars(get_info('nome', $_GET['indicacao'])); ?>" disabled>
                <input class="form-control mb-3" type="hidden" name="indicador" value="<?php echo htmlspecialchars($_GET['indicacao']); ?>">
            </div>
        <?php endif; ?>
        
        <!-- Nome Completo -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>Nome*</label>
            <input class="form-control mb-3" type="text" name="nome" placeholder="Arthur Oliver" required>
        </div>

        <!-- CPF -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>CPF*</label>
            <input class="form-control mb-3 cpf" type="text" name="cpf" placeholder="000.000.000-00" minlength="14" required>
        </div>

        <!-- Data de Nascimento -->
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
            <label>Nascimento</label>
            <input class="form-control mb-3 birthdate" type="text" id="nascimento" name="nascimento" placeholder="01/01/2000" required>
        </div>

        <!-- Gênero -->
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
            <label>Gênero</label>
            <select name="genero" id="genero" class="form-control mb-3" required>
                <option value="Masculino">Masculino</option>
                <option value="Feminino">Feminino</option>
                <option value="N/F">Não informar</option>
            </select>
        </div>

        <!-- E-mail -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>E-mail</label>
            <input class="form-control mb-3" type="email" name="email" placeholder="john@gmail.com">
        </div>

        <!-- Celular -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>Celular</label>
            <input class="form-control mb-3 phone_with_ddd" type="text" name="celular" placeholder="(00) 00000-0000" minlength="15">
        </div>

        <!-- Endereço -->
        <div class="col-lg-9 col-md-8 col-sm-8 col-xs-8">
            <label>CEP</label>
            <input class="form-control mb-3 cep" type="text" name="cep" placeholder="(00) 00000-000" minlength="9" id="cep" required>
        </div>
        <div class="col-lg-3 col-md-4 col-sm-4 col-xs-4">
            <label>Nº</label>
            <input class="form-control mb-3" type="text" name="numero" placeholder="Nº" required maxlength="4" id="numero">
        </div>
        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-4" style="display: none;">
            <label>Estado</label>
            <input class="form-control mb-3" type="text" name="estado" placeholder="" id="uf">
        </div>
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12 address">
            <label>Rua</label>
            <input class="form-control mb-3" type="text" name="rua" placeholder="" required id="rua">
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 address">
            <label>Cidade</label>
            <!-- <input class="form-control mb-3" type="text" name="cidade" placeholder="" id="cidade"> -->
            <select id="cidade" name="cidade" class="form-control mb-3" required>
                <option value="">Selecione sua cidade</option>
            </select>
        </div>
        <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 address">
            <label>Bairro</label>
            <input class="form-control mb-3" type="text" name="bairro" placeholder="" required id="bairro">
        </div>
        <!-- Senha -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>Senha*</label>
            <input class="form-control mb-3" type="password" name="password" minlength="6" required>
        </div>

        <!-- Confirmar Senha -->
        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
            <label>Confirmar senha*</label>
            <input class="form-control mb-3" type="password" name="confirmar-password" minlength="6" required>
        </div>

        <!-- Termos de uso e LGPD -->
        <div class="form-check lgpd col-lg-12 mb-3">
            <input type="checkbox" class="form-check-input mx-0" name="lgpd" id="lgpd" required>
            <span class="mt-1 mx-1">Aceito os <a href="<?php echo esc_url( get_privacy_policy_url() ); ?>" target="_blank">termos de uso</a> e <a href="<?php echo esc_url( get_privacy_policy_url() ); ?>" target="_blank">Política de Privacidade</a></span>
        </div>

        <p class="message mb-3">message</p>

        <div class="d-flex btn-login">
            <button type="submit" class="btnDefault load">Cadastrar</button>
        </div>

    </form>

    <div id="googleBtnRegister" class="d-flex justify-content-center my-2"></div>

    <p class="text-center mt-5">Você já tem um cadastro?</p>
    <div class="d-flex btns">
        <a onclick="changeStep(1)" class="createAccount">Entrar</a>
    </div>

</section>