<?php  if (isset($_SESSION['usuario'])) { echo "<script>window.location.href='".home_url()."/ofertas/'</script>"; exit(); } 

  $register_simpliefied = get_field('cadastro_simplificado', 'options');
?>


<section class="head__app" style="background-image: url('<?= get_data('app_config', 'background'); ?>');">
    <div class="container-fluid">
        <h2 id="step-title">Carregando...</h2>
        <p id="step-description">Aguarde</p>
    </div>
</section>

<section class="body__app">
    <div class="container-fluid" id="step-content">
        <!-- Conteúdo será injetado via JS -->
    </div>
</section>

<script>

let register_simpliefied = '<?= $register_simpliefied; ?>';

const steps = {
    0: {
        title: "<div class='logo'><img src='<?= get_data('app_config', 'logo') ?>' alt='Logo'></div>",
        description: "",
        content: `<?php ob_start(); include 'steps/step-welcome.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    },
    1: {
        title: "Acessar Clube",
        description: "Informe seus dados para acessar",
        content: `<?php ob_start(); include 'steps/step-login.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    },
    2: {

      <?php if ($register_simpliefied) { ?>
        title: "Cadastre-se",
        description: "Complete seus dados para fazer parte do clube",
        content: `<?php ob_start(); include 'steps/step-register-simpliefied.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
      <?php } else { ?>
        title: "Cadastre-se",
        description: "Complete seus dados para fazer parte do clube",
        content: `<?php ob_start(); include 'steps/step-register.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
      <?php } ?>
    },
    3: {
        title: "Recuperar senha",
        description: "Escolha como quer recuperar sua senha",
        content: `<?php ob_start(); include 'steps/step-forgot-password.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    },
    4: {
        title: "Verificação",
        description: "Digite o código enviado para você",
        content: `<?php ob_start(); include 'steps/step-verify-code-forgot-password.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    },
    5: {
        title: "Redefinir Senha",
        description: "Digite e confirme sua nova senha",
        content: `<?php ob_start(); include 'steps/step-password-reset.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    },
    6: {
        title: "Finalizar Cadastro",
        description: "Precisamos de alguns dados para ativar seus benefícios.",
        content: `<?php ob_start(); include 'steps/step-register-complete.php'; echo preg_replace('/\s+/', ' ', ob_get_clean()); ?>`
    }
};

/** RENDERIZA O BOTÃO DO GOOGLE APÓS O STEP EXISTIR NO DOM */
const GOOGLE_CLIENT_ID = '252915568566-cfevejp4p92eteco5u2fsbob4j2v645r.apps.googleusercontent.com';

function renderGoogle(targetId, context){
    function doRender(){
        if (!window.google || !google.accounts || !google.accounts.id) return false;
        google.accounts.id.initialize({
            client_id: GOOGLE_CLIENT_ID,
            callback: onGoogleCredential,
            ux_mode: 'popup',
            context: context // 'signin' ou 'signup'
        });
        const el = document.getElementById(targetId);
        if (el) {
            google.accounts.id.renderButton(el, {
                theme: 'outline',
                size: 'large',
                text: (context === 'signup' ? 'signup_with' : 'continue_with'),
                shape: 'rectangular',
                logo_alignment: 'left'
            });
        }
        return true;
    }
    // tenta imediatamente; se GIS ainda não carregou, tenta por alguns segundos
    if (doRender()) return;
    let tries = 0;
    const t = setInterval(()=>{
        tries++;
        if (doRender() || tries > 40) clearInterval(t); // ~10s
    }, 250);
}

/** INJETA O STEP E SÓ ENTÃO RENDERIZA OS BOTÕES */
function changeStep(step) {
    const stepData = steps[step];
    if (!stepData) return;

    document.getElementById('step-title').innerHTML = stepData.title;
    document.getElementById('step-description').innerHTML = stepData.description;
    document.getElementById('step-content').innerHTML = stepData.content;

    if (step === 2) initCidadesSelect(); // somente no step de cadastro
    if (step === 3) initForgotPasswordTabs();

    // Reativa os eventos do seu auth
    initAuthEvents();

    // Agora que o HTML existe, renderiza os botões do Google
    if (step === 1) renderGoogle('googleBtn', 'signin');          // container em step-login.php
    if (step === 2) renderGoogle('googleBtnRegister', 'signup');  // container em step-register.php
}

document.addEventListener('DOMContentLoaded', function() {
    changeStep(0);
});
</script>
<script>
/* Aguarda jQuery ficar disponível */
(function waitForJQ() {
  if (!window.jQuery) { setTimeout(waitForJQ, 100); return; }

  (function ($) {

    /* ============ CEP → auto-preencher endereço no step 6 ============ */
    $(document).on('blur', '#cep_google', function () {
      var cep = $(this).val().replace(/\D/g, '');
      if (cep.length !== 8) return;
      $.getJSON("https://viacep.com.br/ws/" + cep + "/json/?callback=?", function (dados) {
        if (!("erro" in dados)) {
          if (dados.logradouro) $('#rua_google').val(dados.logradouro);
          if (dados.bairro)     $('#bairro_google').val(dados.bairro);
          if (dados.localidade) $('#cidade_google').val(dados.localidade);
          if (dados.uf)         $('#estado_google').val(dados.uf);
        }
      });
    });

    /* ============ Submit do step de completar cadastro (step 6) ============ */
    $(document).on('submit', '#cadastro-complete', function (e) {
      e.preventDefault();
      const $btn = $('#btnSalvarCompletar').prop('disabled', true).text('Salvando...');

      $.ajax({
        url: "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-complete-profile.php",
        method: "POST",
        data: $(this).serialize(),
        dataType: "json"
      })
      .done(function (data) {
        if (data && data.success) {
          window.location.href = '/ofertas/';
        } else {
          $('.step-6 .message').text((data && data.message) || 'Erro ao salvar.').show();
          $btn.prop('disabled', false).text('Salvar e continuar');
        }
      })
      .fail(function (xhr) {
        $('.step-6 .message').text('Erro de rede.').show();
        $btn.prop('disabled', false).text('Salvar e continuar');
        console.error('complete-profile FAIL', xhr.status, xhr.responseText);
      });
    });

    /* ============ Callback do Google — decide se vai para o step 6 ============ */
    if (typeof window.onGoogleCredential === 'undefined') {
      window.onGoogleCredential = function (response) {
        const cred = response && response.credential;
        if (!cred) return;

        Swal.fire({ title: 'Conectando...', didOpen: () => Swal.showLoading(), allowOutsideClick: false });

        $.ajax({
          url: "/wp-content/themes/app/mobile-view/server-side/access-control/logged-out/server-processing-google.php",
          method: "POST",
          data: { credential: cred },
          dataType: "json"           // << já esperamos JSON do PHP
        })
        .done(function (data) {
          Swal.close();

          if (!data || !data.success) {
            return Swal.fire({
              icon: 'error',
              title: 'Falha no Google',
              text: (data && data.message) || 'Não foi possível autenticar.'
            });
          }

          if (data.need_complete) {
            // vai para o step com o formulário de complementação
            changeStep(6);
            // garante máscaras/validadores após o step ser injetado
            if (typeof initAuthEvents === 'function') {
              setTimeout(initAuthEvents, 0);
            }
          } else {
            window.location.href = '/ofertas/';
          }
        })
        .fail(function (xhr) {
          Swal.close();
          Swal.fire({ icon: 'error', title: 'Erro', text: 'Falha ao comunicar com o servidor.' });
          console.error('server-processing-google.php FAIL', xhr.status, xhr.responseText);
        });
      };
    }

    /* Opcional: exigir complementação após login por CPF+senha */
    window.requireCompletionAfterLogin = function () {
      changeStep(6);
      if (typeof initAuthEvents === 'function') {
        setTimeout(initAuthEvents, 0);
      }
    };

  })(jQuery);

})();
</script>